/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.processors;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.debug.error.ExceptionErrorDebug;
import com.builtbroken.mc.debug.error.IErrorDebug;
import com.builtbroken.mc.framework.json.data.JsonItemEntry;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class JsonGenData
implements IJsonGenObject {
    @JsonProcessorData(value={"author"})
    public String author;
    @JsonProcessorData(value={"mod", "modID"})
    public String modID;
    public final IJsonProcessor processor;
    protected boolean broken = false;
    protected List<IErrorDebug> errors;

    public JsonGenData(IJsonProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void onCreated() {
    }

    @Override
    public void setAuthor(String name) {
        this.author = name;
    }

    @Override
    public String getLoader() {
        return this.processor.getJsonKey();
    }

    @Override
    public String getMod() {
        return this.modID;
    }

    public Object convertItemEntry(Object object) {
        if (object instanceof JsonItemEntry) {
            try {
                return ((JsonItemEntry)object).get();
            }
            catch (IllegalArgumentException e) {
                Engine.logger().error("Error in recipe data " + this, (Throwable)e);
            }
        } else if (object instanceof String) {
            String in = (String)object;
            if (in.startsWith("tool@")) {
                return in;
            }
            if (in.startsWith("ore@")) {
                String oreName = in.substring(4, in.length());
                if (!OreDictionary.doesOreNameExist((String)oreName)) {
                    Engine.logger().error("The ore value of [" + oreName + "] is not register and will prevent the recipe from working. Recipe -> " + this);
                }
                return oreName;
            }
            if (in.startsWith("item@")) {
                return this.findItem(in.substring(5, in.length()));
            }
            if (in.startsWith("block@")) {
                return this.findBlock(in.substring(6, in.length()));
            }
            if (in.contains(":")) {
                Object out = this.findBlock(in);
                if (out == null) {
                    out = this.findItem(in);
                }
                return out;
            }
            if (OreDictionary.doesOreNameExist((String)in)) {
                return in;
            }
            Engine.logger().error("Could not match value of [" + in + "] to any data set for items, blocks, or ore names. Recipe -> " + this);
        }
        return null;
    }

    protected boolean canConvertToItem(Object object) {
        return object instanceof String || object instanceof JsonItemEntry;
    }

    protected Object findBlock(String blockName) {
        if (blockName.contains("@")) {
            String[] data = blockName.split("@");
            blockName = data[0];
            int meta = Integer.parseInt(data[1]);
            Block block = InventoryUtility.getBlock(blockName);
            if (block == null) {
                Engine.logger().error("The block value of [" + blockName + "] is not register and will prevent the recipe from working. Recipe -> " + this);
                return null;
            }
            return new ItemStack(block, 1, meta);
        }
        return InventoryUtility.getBlock(blockName);
    }

    protected Object findItem(String itemName) {
        if (itemName.contains("@")) {
            String[] data = itemName.split("@");
            itemName = data[0];
            int meta = Integer.parseInt(data[1]);
            Item item = InventoryUtility.getItem(itemName);
            if (item == null) {
                Engine.logger().error("The item value of [" + itemName + "] is not register and will prevent the recipe from working. Recipe -> " + this);
                return null;
            }
            return new ItemStack(item, 1, meta);
        }
        return InventoryUtility.getItem(itemName);
    }

    public ItemStack toStack(Object object) {
        if (object instanceof String && (((String)object).contains("@") || ((String)object).contains(":"))) {
            return this.toStack(this.convertItemEntry((String)object));
        }
        if (object instanceof JsonItemEntry) {
            try {
                return ((JsonItemEntry)object).get();
            }
            catch (IllegalArgumentException e) {
                Engine.logger().error("Error in recipe data " + this, (Throwable)e);
            }
        } else {
            if (object instanceof Item) {
                return new ItemStack((Item)object);
            }
            if (object instanceof Block) {
                return new ItemStack((Block)object);
            }
            if (object instanceof String) {
                String orename = (String)object;
                ArrayList stacks = OreDictionary.getOres((String)orename);
                for (ItemStack stack : stacks) {
                    if (stack == null || stack.func_77973_b() == null) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = 1;
                    return copy;
                }
            }
        }
        return object instanceof ItemStack ? (ItemStack)object : null;
    }

    protected void addError(String title, String message, Exception e) {
        if (this.errors == null) {
            this.errors = new ArrayList<IErrorDebug>();
        }
        this.errors.add(new ExceptionErrorDebug(title, message, e));
        this.broken = true;
    }
}

