/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.multiblock.types;

import cofh.api.energy.IEnergyHandler;
import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.api.tile.ConnectionType;
import com.builtbroken.mc.api.tile.ITileConnection;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import com.builtbroken.mc.framework.multiblock.TileMulti;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMultiEnergy
extends TileMulti
implements IEnergyBufferProvider,
ITileConnection,
IEnergyHandler {
    @Override
    public boolean canConnect(TileEntity connection, ConnectionType type, ForgeDirection from) {
        if (this.getHost() instanceof ITileConnection) {
            return ((ITileConnection)((Object)this.getHost())).canConnect(connection, type, from);
        }
        return type == ConnectionType.POWER && this.getHost() instanceof IEnergyBufferProvider;
    }

    @Override
    public boolean hasConnection(ConnectionType type, ForgeDirection side) {
        if (this.getHost() instanceof ITileConnection) {
            return ((ITileConnection)((Object)this.getHost())).hasConnection(type, side);
        }
        return false;
    }

    @Override
    public IEnergyBuffer getEnergyBuffer(ForgeDirection side) {
        if (this.getHost() instanceof IEnergyBufferProvider) {
            return ((IEnergyBufferProvider)((Object)this.getHost())).getEnergyBuffer(side);
        }
        return null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            int received = buffer.addEnergyToStorage(UniversalEnergySystem.RF_HANDLER.toUEEnergy(maxReceive), !simulate);
            return UniversalEnergySystem.RF_HANDLER.fromUE(received);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            int extracted = buffer.removeEnergyFromStorage(UniversalEnergySystem.RF_HANDLER.toUEEnergy(maxExtract), !simulate);
            return UniversalEnergySystem.RF_HANDLER.fromUE(extracted);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            return UniversalEnergySystem.RF_HANDLER.fromUE(buffer.getEnergyStored());
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            return UniversalEnergySystem.RF_HANDLER.fromUE(buffer.getMaxBufferSize());
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        ForgeDirection dir = from;
        TileEntity connector = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (connector != null) {
            return this.canConnect(connector, ConnectionType.RF_POWER, from) || this.canConnect(connector, ConnectionType.POWER, from);
        }
        return false;
    }
}

