/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.thread.action;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeAudio;
import com.builtbroken.mc.api.edit.IWorldChangeGraphics;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.process.IWorldAction;
import com.builtbroken.mc.core.Engine;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.world.World;

public class WorldEditQueue
extends LinkedList<IWorldEdit>
implements IWorldAction {
    public final World world;
    protected final IWorldChangeAction action;
    protected int editsPerTick;

    public WorldEditQueue(World world, IWorldChangeAction action, int edits) {
        this.world = world;
        this.action = action;
        this.editsPerTick = edits;
    }

    public WorldEditQueue(World world, IWorldChangeAction action, int edits, Collection<IWorldEdit> c) {
        super(c);
        this.world = world;
        this.editsPerTick = edits;
        this.action = action;
    }

    @Override
    public int runQue(World world, Side side) {
        if (world == this.world) {
            try {
                Iterator it = this.iterator();
                int c = 0;
                if (this.editsPerTick == -2) {
                    this.editsPerTick = this.size();
                } else if (this.editsPerTick <= 0) {
                    this.editsPerTick = 100;
                }
                int edits = 0;
                while (it.hasNext() && c++ <= this.editsPerTick) {
                    IWorldEdit edit = (IWorldEdit)it.next();
                    if (edit != null) {
                        try {
                            if (!world.field_72995_K) {
                                this.action.handleBlockPlacement(edit);
                                ++edits;
                            }
                            if (this.action instanceof IWorldChangeAudio) {
                                ((IWorldChangeAudio)((Object)this.action)).playAudioForEdit(edit);
                            }
                            if (this.action instanceof IWorldChangeGraphics) {
                                ((IWorldChangeGraphics)((Object)this.action)).displayEffectForEdit(edit);
                            }
                        }
                        catch (Exception e) {
                            Engine.logger().error("Failed to place block for change action\nSide: " + side + "\nChangeAction: " + this.action + "\nEdit: " + edit, (Throwable)e);
                        }
                    }
                    it.remove();
                }
                if (this.isEmpty()) {
                    if (this.action instanceof IWorldChangeAudio) {
                        ((IWorldChangeAudio)((Object)this.action)).doEndAudio();
                    }
                    if (this.action instanceof IWorldChangeGraphics) {
                        ((IWorldChangeGraphics)((Object)this.action)).doEndDisplay();
                    }
                }
                return edits;
            }
            catch (Exception e) {
                Engine.logger().error("Crash while processing world change " + this.action, (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public boolean isQueDone() {
        return this.isEmpty();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof WorldEditQueue && ((WorldEditQueue)object).size() == this.size()) {
            for (IWorldEdit edit : this) {
                if (((WorldEditQueue)object).contains(edit)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "WorldEditQueue[" + this.action + ", " + this.editsPerTick + ", " + this.hashCode() + "]";
    }
}

