/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.imp.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.data.Direction;
import com.builtbroken.mc.imp.transform.vector.Pos;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos
implements IPos3D,
Comparable<BlockPos> {
    public final int x;
    public final int y;
    public final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(IPos3D pos3D) {
        this.x = pos3D.xi();
        this.y = pos3D.yi();
        this.z = pos3D.zi();
    }

    public BlockPos(IPos3D pos3D, ForgeDirection dir) {
        this.x = pos3D.xi() + dir.offsetX;
        this.y = pos3D.yi() + dir.offsetY;
        this.z = pos3D.zi() + dir.offsetZ;
    }

    public BlockPos(IPos3D pos3D, EnumFacing dir) {
        this.x = pos3D.xi() + dir.func_82601_c();
        this.y = pos3D.yi() + dir.func_96559_d();
        this.z = pos3D.zi() + dir.func_82599_e();
    }

    public BlockPos(IPos3D pos3D, Direction dir) {
        this.x = pos3D.xi() + dir.offsetX;
        this.y = pos3D.yi() + dir.offsetY;
        this.z = pos3D.zi() + dir.offsetZ;
    }

    public double x() {
        return this.x;
    }

    public int xi() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public int yi() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public int zi() {
        return this.z;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.x;
        hash = hash * 31 + this.y;
        hash = hash * 31 + this.z;
        return hash;
    }

    public boolean equals(Object o) {
        return o instanceof IPos3D && this.compare((IPos3D)o) == 0;
    }

    public String toString() {
        return "BlockPos[" + this.xi() + "," + this.yi() + "," + this.zi() + "]";
    }

    @Override
    public int compareTo(BlockPos that) {
        return this.compare(that);
    }

    public int compare(IPos3D that) {
        if (this.x() < (double)that.xi() || this.yi() < that.yi() || this.z < that.zi()) {
            return -1;
        }
        if (this.x() > (double)that.xi() || this.y() > (double)that.yi() || this.z > that.zi()) {
            return 1;
        }
        return 0;
    }

    public boolean isAirBlock(World world) {
        Block block = this.getBlock(world);
        if (block != null) {
            return block.isAir((IBlockAccess)world, this.xi(), this.yi(), this.zi());
        }
        return false;
    }

    public Block getBlock(World world) {
        if (world != null) {
            return world.func_147439_a(this.xi(), this.yi(), this.zi());
        }
        return null;
    }

    public float getHardness(World world) {
        Block block = this.getBlock(world);
        if (block != null) {
            return block.func_149712_f(world, this.xi(), this.yi(), this.zi());
        }
        return -1.0f;
    }

    public boolean isReplaceable(World world) {
        Block block = this.getBlock(world);
        if (block != null) {
            return block.isReplaceable((IBlockAccess)world, this.xi(), this.yi(), this.zi());
        }
        return false;
    }

    public double getResistance(Entity explosionBlameEntity, double x, double y, double z) {
        return 0.0;
    }

    public BlockPos add(int x, int y, int z) {
        return new BlockPos(this.x + x, this.y + y, this.z + z);
    }

    public BlockPos add(Direction direction) {
        return new BlockPos(this.x + direction.offsetX, this.y + direction.offsetY, this.z + direction.offsetZ);
    }

    public boolean canSeeSky(World world) {
        return world != null && world.func_72937_j(this.xi(), this.yi(), this.zi());
    }

    public int getBlockMetadata(World world) {
        if (world != null) {
            return world.func_72805_g(this.xi(), this.yi(), this.zi());
        }
        return 0;
    }

    public double distance(double x, double y, double z) {
        return ((Pos)new Pos(this).add(0.5)).distance(x, y, z);
    }

    public Pos toPos() {
        return new Pos(this.xi(), this.yi(), this.zi());
    }

    public TileEntity getTileEntity(World world) {
        if (world != null) {
            return world.func_147438_o(this.xi(), this.yi(), this.zi());
        }
        return null;
    }

    public double distance(IPos3D center) {
        return this.distance(center.x(), center.y(), center.z());
    }
}

