/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.asm;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.asm.ASMHelper;
import com.builtbroken.mc.lib.asm.ObfMapping;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.tree.ClassNode;

public class ClassHeirachyManager
implements IClassTransformer {
    public static HashMap<String, SuperCache> superclasses = new HashMap();
    private static LaunchClassLoader cl = (LaunchClassLoader)ClassHeirachyManager.class.getClassLoader();

    public static String toKey(String name) {
        if (ObfMapping.obfuscated) {
            name = FMLDeobfuscatingRemapper.INSTANCE.map(name.replace('.', '/')).replace('/', '.');
        }
        return name;
    }

    public static String unKey(String name) {
        if (ObfMapping.obfuscated) {
            name = FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
        }
        return name;
    }

    public static boolean classExtends(String name, String superclass) {
        if ((name = ClassHeirachyManager.toKey(name)).equals(superclass = ClassHeirachyManager.toKey(superclass))) {
            return true;
        }
        SuperCache cache = ClassHeirachyManager.declareClass(name);
        if (cache == null) {
            return false;
        }
        cache.flatten();
        return cache.parents.contains(superclass);
    }

    private static SuperCache declareClass(String name) {
        SuperCache cache = superclasses.get(name = ClassHeirachyManager.toKey(name));
        if (cache != null) {
            return cache;
        }
        try {
            byte[] bytes = cl.getClassBytes(ClassHeirachyManager.unKey(name));
            if (bytes != null) {
                cache = ClassHeirachyManager.declareASM(bytes);
            }
        }
        catch (IOException e) {
            Engine.logger().catching((Throwable)e);
        }
        if (cache != null) {
            return cache;
        }
        try {
            cache = ClassHeirachyManager.declareReflection(name);
        }
        catch (ClassNotFoundException e) {
            Engine.logger().catching((Throwable)e);
        }
        return cache;
    }

    private static SuperCache declareReflection(String name) throws ClassNotFoundException {
        Class<?> aclass = Class.forName(name);
        SuperCache cache = ClassHeirachyManager.getOrCreateCache(name);
        if (aclass.isInterface()) {
            cache.superclass = "java.lang.Object";
        } else {
            if (name.equals("java.lang.Object")) {
                return cache;
            }
            cache.superclass = ClassHeirachyManager.toKey(aclass.getSuperclass().getName());
        }
        cache.add(cache.superclass);
        for (Class<?> iclass : aclass.getInterfaces()) {
            cache.add(ClassHeirachyManager.toKey(iclass.getName()));
        }
        return cache;
    }

    private static SuperCache declareASM(byte[] bytes) {
        ClassNode node = ASMHelper.createClassNode(bytes);
        String name = ClassHeirachyManager.toKey(node.name);
        SuperCache cache = ClassHeirachyManager.getOrCreateCache(name);
        cache.superclass = ClassHeirachyManager.toKey(node.superName.replace('/', '.'));
        cache.add(cache.superclass);
        for (String iclass : node.interfaces) {
            cache.add(ClassHeirachyManager.toKey(iclass.replace('/', '.')));
        }
        return cache;
    }

    public static SuperCache getOrCreateCache(String name) {
        SuperCache cache = superclasses.get(name);
        if (cache == null) {
            cache = new SuperCache();
            superclasses.put(name, cache);
        }
        return cache;
    }

    public static String getSuperClass(String name, boolean runtime) {
        SuperCache cache = ClassHeirachyManager.declareClass(name = ClassHeirachyManager.toKey(name));
        if (cache == null) {
            return "java.lang.Object";
        }
        cache.flatten();
        String s = cache.superclass;
        if (!runtime) {
            s = FMLDeobfuscatingRemapper.INSTANCE.unmap(s);
        }
        return s;
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!superclasses.containsKey(tname)) {
            ClassHeirachyManager.declareASM(bytes);
        }
        return bytes;
    }

    static {
        cl.addTransformerExclusion("codechicken.lib.asm");
    }

    public static class SuperCache {
        public HashSet<String> parents = new HashSet();
        String superclass;
        private boolean flattened;

        public void add(String parent) {
            this.parents.add(parent);
        }

        public void flatten() {
            if (this.flattened) {
                return;
            }
            for (String s : new ArrayList<String>(this.parents)) {
                SuperCache c = ClassHeirachyManager.declareClass(s);
                if (c == null) continue;
                c.flatten();
                this.parents.addAll(c.parents);
            }
            this.flattened = true;
        }
    }
}

