/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.data;

import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.lib.world.map.data.ChunkData;
import com.builtbroken.mc.lib.world.map.data.ChunkMapManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public abstract class ChunkMap<C extends ChunkData>
implements IVirtualObject {
    public int dimID;
    protected long ticks = 0L;
    public final HashMap<ChunkCoordIntPair, C> chunks = new HashMap();
    public final ChunkMapManager mapManager;

    public ChunkMap(ChunkMapManager mapManager, int dimID) {
        this.mapManager = mapManager;
        this.dimID = dimID;
        if (!Engine.isJUnitTest()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            SaveManager.register(this);
        }
    }

    public void update() {
        if (this.ticks % 200L == 0L) {
            // empty if block
        }
    }

    public C getChunkFromBlockCoords(int x, int z) {
        return this.getChunk(x >> 4, z >> 4);
    }

    public C getChunk(int x, int z) {
        ChunkCoordIntPair coords = new ChunkCoordIntPair(x, z);
        if (this.chunks.containsKey(coords)) {
            return (C)((ChunkData)this.chunks.get(coords));
        }
        return null;
    }

    protected C add(C chunk) {
        this.chunks.put(((ChunkData)chunk).position, chunk);
        return chunk;
    }

    @SubscribeEvent
    public void onChunkLoaded(ChunkEvent.Load event) {
        Chunk chunk = event.getChunk();
        ChunkCoordIntPair coords = chunk.func_76632_l();
        if (this.chunks.containsKey(coords)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onChunkUnloaded(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        ChunkCoordIntPair coords = chunk.func_76632_l();
        if (this.chunks.containsKey(coords)) {
            this.chunks.remove(coords);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g == this.dimID) {
            this.saveAll();
        }
    }

    public void onWorldUnload() {
        this.saveAll();
    }

    public int dimID() {
        return this.dimID;
    }

    public boolean shouldUnload() {
        return this.chunks.isEmpty();
    }

    @Override
    public File getSaveFile() {
        return this.mapManager != null ? this.mapManager.getSaveFile(this.dimID) : null;
    }

    @Override
    public void load(NBTTagCompound nbt) {
    }

    public void onLoad() {
    }

    public void saveAll() {
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        return nbt;
    }

    @Override
    public boolean shouldSaveForWorld(World world) {
        return this.mapManager != null && this.dimID == world.field_73011_w.field_76574_g && !world.field_72995_K;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() == this.getClass()) {
            return ((ChunkMap)object).dimID == this.dimID;
        }
        return false;
    }

    public void clear() {
        this.chunks.clear();
    }
}

