/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.heat;

import com.builtbroken.jlib.data.science.units.TemperatureUnit;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.data.heat.HeatedBlockRegistry;
import com.builtbroken.mc.lib.world.map.heat.HeatMap;
import java.util.HashMap;
import net.minecraft.world.World;

public class HeatDataManager {
    private static HashMap<Integer, HeatMap> dims = new HashMap();
    private static int default_return = 293;

    public static HeatMap getMapForWorld(World world) {
        return HeatDataManager.getMapForDim(world.field_73011_w.field_76574_g);
    }

    public static HeatMap getMapForDim(int dim) {
        if (!dims.containsKey(dim)) {
            dims.put(dim, new HeatMap(dim));
        }
        return dims.get(dim);
    }

    public static int getTempKelvin(Location location) {
        return HeatDataManager.getTempKelvin(location.world, location.xi(), location.yi(), location.zi());
    }

    public static int getTempKelvin(World world, int x, int y, int z) {
        return HeatedBlockRegistry.getDefaultTemp(world, world.func_147439_a(x, y, z));
    }

    public static int getTempFahrenheit(Location location) {
        return (int)TemperatureUnit.Fahrenheit.conversion.fromKelvin((float)default_return);
    }

    public static int getTempCelsius(Location location) {
        return (int)TemperatureUnit.Celsius.conversion.fromKelvin((float)default_return);
    }
}

