/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.radiation;

import com.builtbroken.mc.lib.world.map.data.ChunkMap;
import com.builtbroken.mc.lib.world.map.data.s.ChunkDataShort;
import com.builtbroken.mc.lib.world.map.radiation.RadiationDataManager;

public class RadiationMap
extends ChunkMap<ChunkDataShort> {
    public RadiationMap(RadiationDataManager manager, int dimID) {
        super(manager, dimID);
    }

    public short getRadiation(int x, int y, int z) {
        ChunkDataShort chunk = (ChunkDataShort)this.getChunkFromBlockCoords(x, z);
        if (chunk != null) {
            return chunk.getValue(x & 0xF, y, z & 0xF);
        }
        return 0;
    }

    public short setRadiation(int x, int y, int z, short value) {
        ChunkDataShort chunk = (ChunkDataShort)this.getChunkFromBlockCoords(x, z);
        if (chunk != null) {
            short prev = chunk.getValue(x & 0xF, y, z & 0xF);
            chunk.setValue(x & 0xF, y, z & 0xF, value);
            return prev;
        }
        chunk = this.add(new ChunkDataShort(x >> 4, z >> 4));
        chunk.setValue(x & 0xF, y, z & 0xF, value);
        return 0;
    }

    public String toString() {
        return "RadiationMap[" + this.dimID + "]";
    }
}

