/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.tile;

import com.builtbroken.mc.api.event.tile.TileEvent;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.multiblock.TileMulti;
import com.builtbroken.mc.lib.world.map.radar.RadarMap;
import com.builtbroken.mc.lib.world.map.radar.data.RadarObject;
import com.builtbroken.mc.lib.world.map.radar.data.RadarTile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

@Deprecated
public final class TileMapRegistry {
    public static final TileMapRegistry INSTANCE = new TileMapRegistry();
    public static int CHUNKS_TO_SCAN_PER_TICK = 10;
    public static long CHUNKS_SCAN_TIME_LIMIT_NS = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS);
    private static final HashMap<Integer, RadarMap> WORLD_TO_MAP = new HashMap();
    private static final HashMap<Integer, Queue<ChunkCoordIntPair>> CHUNKS_TO_SCAN = new HashMap();

    public static boolean add(TileEntity tile) {
        if (tile != null && tile.func_145831_w() != null && !tile.func_145831_w().field_72995_K) {
            RadarMap map = TileMapRegistry.getRadarMapForWorld(tile.func_145831_w());
            return map != null ? TileMapRegistry.getRadarMapForWorld(tile.func_145831_w()).add(tile) : false;
        }
        return false;
    }

    public static boolean remove(TileEntity tile) {
        if (tile != null && tile.func_145831_w() != null) {
            RadarMap map = TileMapRegistry.getRadarMapForWorld(tile.func_145831_w());
            return map != null ? TileMapRegistry.getRadarMapForWorld(tile.func_145831_w()).remove(tile) : false;
        }
        return false;
    }

    public static RadarMap getRadarMapForWorld(World world) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_72995_K) {
                if (Engine.runningAsDev) {
                    Engine.logger().error("RadarRegistry: Radar data can not be requested client side.", (Throwable)new RuntimeException());
                }
                return null;
            }
            return TileMapRegistry.getRadarMapForDim(world.field_73011_w.field_76574_g);
        }
        if (Engine.runningAsDev) {
            Engine.logger().error("RadarRegistry: World can not be null or have a null provider when requesting a radar map", (Throwable)new RuntimeException());
        }
        return null;
    }

    public static RadarMap getRadarMapForDim(int dimID) {
        if (!WORLD_TO_MAP.containsKey(dimID)) {
            RadarMap map = new RadarMap(dimID);
            WORLD_TO_MAP.put(dimID, map);
            return map;
        }
        return WORLD_TO_MAP.get(dimID);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        int dim;
        if (event.getChunk().field_76637_e != null && event.getChunk().field_76637_e.field_73011_w != null && WORLD_TO_MAP.containsKey(dim = event.getChunk().field_76637_e.field_73011_w.field_76574_g)) {
            TileMapRegistry.getRadarMapForDim(dim).remove(event.getChunk());
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        Chunk chunk = event.getChunk();
        World world = chunk.field_76637_e;
        if (world != null && world.field_73011_w != null) {
            int dim = world.field_73011_w.field_76574_g;
            if (!CHUNKS_TO_SCAN.containsKey(dim)) {
                CHUNKS_TO_SCAN.put(dim, new LinkedList());
            }
            CHUNKS_TO_SCAN.get(dim).offer(chunk.func_76632_l());
        }
    }

    @SubscribeEvent
    public void worldUpdateTick(TickEvent.WorldTickEvent event) {
        int dim;
        World world = event.world;
        if (world.field_73011_w != null && event.side == Side.SERVER && event.phase == TickEvent.Phase.END && WORLD_TO_MAP.containsKey(dim = world.field_73011_w.field_76574_g)) {
            Queue<ChunkCoordIntPair> queue;
            RadarMap map = TileMapRegistry.getRadarMapForDim(dim);
            if (map.chunk_to_entities.isEmpty()) {
                WORLD_TO_MAP.remove(dim);
            } else {
                map.update();
            }
            if (CHUNKS_TO_SCAN.containsKey(dim) && !(queue = CHUNKS_TO_SCAN.get(dim)).isEmpty()) {
                int count = 0;
                long start = System.nanoTime();
                while (queue.peek() != null && count < CHUNKS_TO_SCAN_PER_TICK && System.nanoTime() - start < CHUNKS_SCAN_TIME_LIMIT_NS) {
                    ChunkCoordIntPair position = queue.poll();
                    if (world.func_72863_F().func_73149_a(position.field_77276_a, position.field_77275_b)) {
                        Chunk chunk = world.func_72964_e(position.field_77276_a, position.field_77275_b);
                        if (chunk == null) continue;
                        Map tiles = chunk.field_150816_i;
                        for (TileEntity tile : tiles.values()) {
                            if (tile.func_145837_r()) continue;
                            TileMapRegistry.add(tile);
                        }
                        continue;
                    }
                    if (!Engine.runningAsDev) continue;
                    Engine.logger().warn("TileMapRegistry#worldUpdateTick() >> Dim[" + dim + "] >> Chunk" + position + " was queue for scan but did not exist when polled for scan\nThis is likely a problem with map unloading or loading too often.");
                }
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        int dim;
        if (event.world.field_73011_w != null && !event.world.field_72995_K && WORLD_TO_MAP.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            TileMapRegistry.getRadarMapForDim(dim).unloadAll();
            WORLD_TO_MAP.remove(dim);
        }
    }

    @SubscribeEvent
    public void onTileLoaded(TileEvent.TileLoadEvent event) {
        if (event.world.field_73011_w != null && !event.world.field_72995_K) {
            this.removeTilesAtLocation(event.world, event.x, event.y, event.z);
            if (event.tile() != null) {
                if (!(event.tile() instanceof TileMulti)) {
                    boolean added = TileMapRegistry.add(event.tile());
                    if (Engine.runningAsDev) {
                        if (added) {
                            Engine.logger().info("Added tile to TileMap. Tile = " + event.tile());
                        } else {
                            Engine.logger().info("Failed to add tile to TileMap. Tile = " + event.tile());
                        }
                    }
                }
            } else if (Engine.runningAsDev) {
                Engine.logger().info("Error something tried to add a null tile to the map", (Throwable)new RuntimeException());
            }
        }
    }

    @SubscribeEvent
    public void onTileLoaded(TileEvent.TileUnLoadEvent event) {
        if (event.world.field_73011_w != null && !event.world.field_72995_K) {
            this.removeTilesAtLocation(event.world, event.x, event.y, event.z);
        }
    }

    public void removeTilesAtLocation(World world, int x, int y, int z) {
        RadarMap map = TileMapRegistry.getRadarMapForWorld(world);
        if (map != null) {
            List<RadarObject> list = map.getRadarObjects(x, z, 5.0);
            for (RadarObject object : list) {
                if (!(object instanceof RadarTile) || !((RadarTile)object).tile.func_145837_r() && (object.xi() != x || object.yi() != y || object.zi() != z)) continue;
                map.remove(object);
            }
        }
    }
}

