/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.mods;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.mod.AbstractMod;
import com.builtbroken.mc.framework.mod.AbstractProxy;
import com.builtbroken.mc.framework.mod.Mods;
import com.builtbroken.mc.mods.CommonProxy;
import com.builtbroken.mc.mods.ae.AEProxy;
import com.builtbroken.mc.mods.bc.BCProxy;
import com.builtbroken.mc.mods.ic.ICProxy;
import com.builtbroken.mc.mods.mek.MekProxy;
import com.builtbroken.mc.mods.nei.JsonProcessorHideItem;
import com.builtbroken.mc.mods.nei.NEIProxy;
import com.builtbroken.mc.mods.pe.ProjectEProxy;
import com.builtbroken.mc.mods.rf.RFLoader;
import com.builtbroken.mc.mods.te.TEProxy;
import com.builtbroken.mc.mods.tinkers.TinkerProxy;
import com.builtbroken.mc.mods.waila.WailaLoader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="voltzenginemodcompat", name="Voltz Engine Mod Compatibility Loader", version="1.9.14.302", dependencies="required-after:voltzengine")
public class ModCompatLoader
extends AbstractMod {
    public static final String DOMAIN = "voltzenginemodcompat";
    @SidedProxy(modId="voltzenginemodcompat", clientSide="com.builtbroken.mc.mods.CommonProxy", serverSide="com.builtbroken.mc.mods.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="voltzenginemodcompat")
    public static ModCompatLoader instance;

    public ModCompatLoader() {
        super(DOMAIN);
    }

    @Override
    public void loadJsonContentHandlers() {
        super.loadJsonContentHandlers();
        JsonContentLoader.INSTANCE.add(new JsonProcessorHideItem());
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.fireProxyPreInit = false;
        super.preInit(event);
        Engine.loaderInstance.getConfig().setCategoryComment("Mod_Support", "If true the proxy class for the mod will be loaded enabling support, set to false if support is not required or breaks the game.");
        this.loader.applyModule(NEIProxy.class, Mods.NEI.isLoaded());
        this.loader.applyModule(TinkerProxy.class, Mods.TINKERS.isLoaded());
        this.loader.applyModule(AEProxy.class, Mods.AE.isLoaded());
        this.loader.applyModule(ICProxy.class, Mods.IC2.isLoaded());
        this.loader.applyModule(BCProxy.class, Mods.BC.isLoaded());
        this.loader.applyModule(MekProxy.class, Mods.MEKANISM.isLoaded());
        this.loader.applyModule(ProjectEProxy.class, Mods.PROJECT_E.isLoaded());
        this.loader.applyModule(WailaLoader.class, Mods.WAILA.isLoaded());
        boolean shouldLoadRFHandler = true;
        for (String s : new String[]{"IEnergyConnection", "IEnergyContainerItem", "IEnergyHandler", "IEnergyProvider", "IEnergyReceiver", "IEnergyStorage"}) {
            try {
                Class<?> clazz = Class.forName("cofh.api.energy." + s, false, this.getClass().getClassLoader());
                if (clazz != null) continue;
                shouldLoadRFHandler = false;
                break;
            }
            catch (ClassNotFoundException e) {
                shouldLoadRFHandler = false;
                Engine.logger().error("Not loading RF support as we couldn't detect cofh.api.energy." + s + " class or interface.");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (shouldLoadRFHandler) {
            this.loader.applyModule(RFLoader.class);
            this.loader.applyModule(TEProxy.class, Mods.TF_EXPANSION.isLoaded());
        }
        this.loader.preInit();
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        super.loadComplete(event);
    }

    @Override
    public AbstractProxy getProxy() {
        return proxy;
    }
}

