/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.gui.components;

import com.builtbroken.mc.prefab.gui.components.GuiComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;

public class GuiField
extends GuiComponent<GuiField> {
    private String text = "";
    private int maxStringLength = 32;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private long unfocusedTime = 0L;

    public GuiField(int x, int y) {
        super(-1, x, y);
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String text) {
        if (text != null) {
            this.text = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
            this.setCursorPositionEnd();
        } else {
            this.setText("");
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void writeText(String text) {
        int l;
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)text);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - this.selectionEnd);
        boolean flag = false;
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int p_146177_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(p_146177_1_) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = p_146175_1_ < 0;
                int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(p_146175_1_);
                }
            }
        }
    }

    public int getNthWordFromCursor(int p_146187_1_) {
        return this.getNthWordFromPos(p_146187_1_, this.getCursorPosition());
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.func_146197_a(p_146183_1_, this.getCursorPosition(), true);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.text.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.text.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((k = this.text.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.text.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.selectionEnd + p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyTyped(char p_146201_1_, int p_146201_2_) {
        if (!this.isFocused) {
            return false;
        }
        switch (p_146201_1_) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                return true;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case '\u0016': {
                if (this.isEnabled()) {
                    this.writeText(GuiScreen.func_146277_j());
                }
                return true;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (this.isEnabled()) {
                    this.writeText("");
                }
                return true;
            }
        }
        switch (p_146201_2_) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.deleteWords(-1);
                    }
                } else if (this.isEnabled()) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.deleteWords(1);
                    }
                } else if (this.isEnabled()) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)p_146201_1_)) {
            if (this.isEnabled()) {
                this.writeText(Character.toString(p_146201_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.setFocused(true);
            if (this.isFocused) {
                int l = mouseX - this.x();
                if (this.enableBackgroundDrawing) {
                    l -= 4;
                }
                String s = Minecraft.func_71410_x().field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
                this.setCursorPosition(Minecraft.func_71410_x().field_71466_p.func_78269_a(s, l).length() + this.lineScrollOffset);
            }
            return true;
        }
        this.setFocused(false);
        return false;
    }

    @Override
    protected void preRender(Minecraft mc, int mouseX, int mouseY) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }

    @Override
    protected void postRender(Minecraft mc, int mouseX, int mouseY) {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
    }

    @Override
    protected void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        if (this.getEnableBackgroundDrawing()) {
            GuiField.func_73734_a((int)(this.x() - 1), (int)(this.y() - 1), (int)(this.x() + this.getWidth() + 1), (int)(this.y() + this.getHeight() + 1), (int)-6250336);
            GuiField.func_73734_a((int)this.x(), (int)this.y(), (int)(this.x() + this.getWidth()), (int)(this.y() + this.getHeight()), (int)-16777216);
        }
    }

    @Override
    protected void doRender(Minecraft mc, int mouseX, int mouseY) {
        super.doRender(mc, mouseX, mouseY);
        int textRenderColor = this.getTextColor();
        int renderedCursorPosition = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = Minecraft.func_71410_x().field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
        boolean flag = renderedCursorPosition >= 0 && renderedCursorPosition <= s.length();
        boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.enableBackgroundDrawing ? this.x() + 4 : this.x();
        int i1 = this.enableBackgroundDrawing ? this.y() + (this.getHeight() - 8) / 2 : this.y();
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, renderedCursorPosition) : s;
            j1 = Minecraft.func_71410_x().field_71466_p.func_78261_a(s1, l, i1, textRenderColor);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = renderedCursorPosition > 0 ? l + this.getWidth() : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (s.length() > 0 && flag && renderedCursorPosition < s.length()) {
            Minecraft.func_71410_x().field_71466_p.func_78261_a(s.substring(renderedCursorPosition), j1, i1, textRenderColor);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + Minecraft.func_71410_x().field_71466_p.field_78288_b), (int)-3092272);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_78261_a("_", k1, i1, textRenderColor);
            }
        }
        if (k != renderedCursorPosition) {
            int l1 = l + Minecraft.func_71410_x().field_71466_p.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + Minecraft.func_71410_x().field_71466_p.field_78288_b);
        }
    }

    private void drawCursorVertical(int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        int i1;
        if (p_146188_1_ < p_146188_3_) {
            i1 = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i1;
        }
        if (p_146188_2_ < p_146188_4_) {
            i1 = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = i1;
        }
        if (p_146188_3_ > this.x() + this.getWidth()) {
            p_146188_3_ = this.x() + this.getWidth();
        }
        if (p_146188_1_ > this.x() + this.getWidth()) {
            p_146188_1_ = this.x() + this.getWidth();
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_2_, 0.0);
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_2_, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    public void setMaxStringLength(int p_146203_1_) {
        this.maxStringLength = p_146203_1_;
        if (this.text.length() > p_146203_1_) {
            this.text = this.text.substring(0, p_146203_1_);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean p_146185_1_) {
        this.enableBackgroundDrawing = p_146185_1_;
    }

    public void setFocused(boolean focused) {
        if (focused && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = focused;
        if (!focused) {
            this.unfocusedTime = System.nanoTime();
        }
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    @Override
    public int getWidth() {
        return this.getEnableBackgroundDrawing() ? super.getWidth() - 8 : super.getWidth();
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        if (p_146199_1_ > j) {
            p_146199_1_ = j;
        }
        if (p_146199_1_ < 0) {
            p_146199_1_ = 0;
        }
        this.selectionEnd = p_146199_1_;
        if (Minecraft.func_71410_x().field_71466_p != null) {
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
            int k = this.getWidth();
            String s = Minecraft.func_71410_x().field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), k);
            int l = s.length() + this.lineScrollOffset;
            if (p_146199_1_ == this.lineScrollOffset) {
                this.lineScrollOffset -= Minecraft.func_71410_x().field_71466_p.func_78262_a(this.text, k, true).length();
            }
            if (p_146199_1_ > l) {
                this.lineScrollOffset += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - p_146199_1_;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
        }
    }

    protected int getTextColor() {
        if (!this.isEnabled()) {
            return 0x707070;
        }
        return 0xE0E0E0;
    }

    public void setCanLoseFocus(boolean p_146205_1_) {
        this.canLoseFocus = p_146205_1_;
    }

    public void setVisible(boolean p_146189_1_) {
        this.field_146125_m = p_146189_1_;
    }

    public long timeSinceFocused() {
        return System.nanoTime() - this.unfocusedTime;
    }
}

