/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.mc.api.IModObject;
import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.api.data.ActionResponse;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.IChangeListener;
import com.builtbroken.mc.framework.block.imp.IPlacementListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.data.BlockStateEntry;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AdjacentPlacementListener
extends TileListener
implements IPlacementListener,
IBlockListener,
IChangeListener {
    @JsonProcessorData(value={"invert"})
    protected boolean invert = false;
    @JsonProcessorData(value={"doBreakCheck"})
    protected boolean doBreakCheck = true;
    protected List<BlockStateEntry> blockList = new ArrayList<BlockStateEntry>();
    protected List<String> contentIDs = new ArrayList<String>();
    protected ForgeDirection[] supportedDirections = null;
    public final Block block;

    public AdjacentPlacementListener(Block block) {
        this.block = block;
    }

    @Override
    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("placement");
        list.add("change");
        return list;
    }

    @Override
    public void onBlockChanged() {
        if (this.doBreakCheck && this.world() != null && this.isValidTileAtLocation() && this.canBlockStay() == ActionResponse.CANCEL) {
            ((World)this.world().unwrap()).func_147480_a(this.xi(), this.yi(), this.zi(), true);
        }
    }

    @Override
    public ActionResponse canPlaceAt(IEntityData entity) {
        if (entity.isPlayer()) {
            ItemStack stack = entity.getRightClickItem();
            if (stack == null || stack.func_77960_j() != this.metaCheck) {
                return ActionResponse.IGNORE;
            }
            if (this.isPlacementValid()) {
                return ActionResponse.DO;
            }
            return ActionResponse.CANCEL;
        }
        return ActionResponse.IGNORE;
    }

    @Override
    public ActionResponse canBlockStay() {
        if (!this.isValidTileAtLocation()) {
            return ActionResponse.IGNORE;
        }
        if (this.isPlacementValid()) {
            return ActionResponse.DO;
        }
        return ActionResponse.CANCEL;
    }

    protected boolean isPlacementValid() {
        Pos center = new Pos(this);
        IBlockAccess access = this.getBlockAccess();
        for (ForgeDirection direction : this.supportedDirections == null ? ForgeDirection.VALID_DIRECTIONS : this.supportedDirections) {
            Pos pos = (Pos)((Object)center.add(direction));
            if (!this.isSupportingTile(access, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSupportingTile(IBlockAccess access, Pos pos) {
        return this.doesContainTile(access, pos, this.blockList, this.contentIDs);
    }

    protected boolean doesContainTile(IBlockAccess access, Pos pos, List<BlockStateEntry> blockList, List<String> contentIDs) {
        Block block = pos.getBlock(access);
        if (block != null) {
            int meta = pos.getBlockMetadata(access);
            if (block != null) {
                for (BlockStateEntry entry : blockList) {
                    if (!entry.matches(block, meta)) continue;
                    return true;
                }
                ArrayList<String> ids = new ArrayList<String>();
                TileEntity tile = pos.getTileEntity(access);
                if (tile != null && !tile.func_145837_r()) {
                    if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() != null) {
                        ids.add(((ITileNodeHost)tile).getTileNode().getMod() + ":" + ((ITileNodeHost)tile).getTileNode().getUniqueID());
                    }
                    if (tile instanceof IModObject) {
                        ids.add(((IModObject)tile).getMod() + ":" + ((IModObject)tile).getUniqueID());
                    }
                }
                if (block instanceof IModObject) {
                    ids.add(((IModObject)block).getMod() + ":" + ((IModObject)block).getUniqueID());
                }
                for (String id : ids) {
                    if (!contentIDs.contains(id.toLowerCase())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidForTile() {
        return true;
    }

    @JsonProcessorData(value={"sides"})
    public void processSides(JsonElement inputElement) {
        if (inputElement.isJsonArray()) {
            ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
            for (JsonElement element : inputElement.getAsJsonArray()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                String value = primitive.getAsString();
                if (value.equalsIgnoreCase("north")) {
                    directions.add(ForgeDirection.NORTH);
                    continue;
                }
                if (value.equalsIgnoreCase("south")) {
                    directions.add(ForgeDirection.SOUTH);
                    continue;
                }
                if (value.equalsIgnoreCase("east")) {
                    directions.add(ForgeDirection.EAST);
                    continue;
                }
                if (value.equalsIgnoreCase("west")) {
                    directions.add(ForgeDirection.WEST);
                    continue;
                }
                if (value.equalsIgnoreCase("up")) {
                    directions.add(ForgeDirection.UP);
                    continue;
                }
                if (!value.equalsIgnoreCase("down")) continue;
                directions.add(ForgeDirection.DOWN);
            }
            this.supportedDirections = directions.toArray(new ForgeDirection[directions.size()]);
        }
    }

    @JsonProcessorData(value={"blocks"})
    public void processBlocks(JsonElement inputElement) {
        if (inputElement.isJsonArray()) {
            for (JsonElement element : inputElement.getAsJsonArray()) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("block")) {
                        String blockName = object.getAsJsonPrimitive("block").getAsString();
                        int meta = -1;
                        if (object.has("data")) {
                            meta = object.getAsJsonPrimitive("data").getAsInt();
                        }
                        this.blockList.add(new BlockStateEntry(blockName, meta));
                        continue;
                    }
                    if (object.has("contentID")) {
                        this.contentIDs.add(object.getAsJsonPrimitive("contentID").getAsString().toLowerCase());
                        continue;
                    }
                    Engine.logger().warn("AdjacentPlacementListener#process(JsonElement) >> Could not find convert '" + element + "' int a usable type for " + this);
                    continue;
                }
                throw new IllegalArgumentException("Invalid data, block entries must look like \n {\n\t \"block\" : \"minecraft:tnt\",\n\t \"data\" : 0 \n}");
            }
        } else {
            throw new IllegalArgumentException("Invalid data, blocks data must be an array");
        }
    }

    public String toString() {
        if (this.contentUseID != null) {
            return "AdjacentPlacementListener[" + this.block + " >> " + this.contentUseID + "]@" + this.hashCode();
        }
        if (this.metaCheck != -1) {
            return "AdjacentPlacementListener[" + this.block + "@" + this.metaCheck + "]@" + this.hashCode();
        }
        return "AdjacentPlacementListener[" + this.block + "]@" + this.hashCode();
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            return new AdjacentPlacementListener(block);
        }

        @Override
        public String getListenerKey() {
            return "adjacentPlacementListener";
        }
    }
}

