/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.mc.api.tile.IRotatable;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.block.imp.IWrenchListener;
import com.builtbroken.mc.lib.helper.BlockUtility;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class WrenchRotationListener
extends TileListener
implements IBlockListener,
IWrenchListener {
    @Override
    public boolean onPlayerRightClickWrench(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        IRotatable rotatable = null;
        TileEntity tile = this.getTileEntity();
        if (tile instanceof IRotatable) {
            rotatable = (IRotatable)tile;
        } else if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof IRotatable) {
            rotatable = (IRotatable)((Object)((ITileNodeHost)tile).getTileNode());
        }
        if (rotatable != null) {
            if (this.isServer()) {
                if (!player.func_70093_af()) {
                    if (rotatable.getDirection() == ForgeDirection.NORTH) {
                        rotatable.setDirection(ForgeDirection.EAST);
                    } else if (rotatable.getDirection() == ForgeDirection.EAST) {
                        rotatable.setDirection(ForgeDirection.SOUTH);
                    } else if (rotatable.getDirection() == ForgeDirection.SOUTH) {
                        rotatable.setDirection(ForgeDirection.WEST);
                    } else if (rotatable.getDirection() == ForgeDirection.WEST) {
                        rotatable.setDirection(ForgeDirection.NORTH);
                    }
                } else {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)BlockUtility.determineRotation(player.field_70177_z));
                    if (rotatable.getDirection() == direction) {
                        rotatable.setDirection(direction.getOpposite());
                    } else {
                        rotatable.setDirection(direction);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("wrench");
        return list;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            return new WrenchRotationListener();
        }

        @Override
        public String getListenerKey() {
            return "wrenchRotation";
        }
    }
}

