/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.replace;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.seven.framework.json.recipe.replace.JsonRecipeReplacementData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class JsonRecipeReplacementProcessor
extends AbstractLoadable
implements IJsonProcessor {
    List<JsonRecipeReplacementData> replacementData = new ArrayList<JsonRecipeReplacementData>();

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "recipeRemoval";
    }

    @Override
    public String getLoadOrder() {
        return "after:oreName";
    }

    @Override
    public boolean canProcess(String key, JsonElement element) {
        return key.equalsIgnoreCase(this.getJsonKey());
    }

    @Override
    public boolean process(JsonElement element, List<IJsonGenObject> entries) {
        JsonObject jsonData = element.getAsJsonObject();
        JsonProcessor.ensureValuesExist(jsonData, "type", "item", "craftingType");
        String type = jsonData.getAsJsonPrimitive("type").getAsString();
        String craftingType = jsonData.getAsJsonPrimitive("craftingType").getAsString();
        String item = jsonData.getAsJsonPrimitive("item").getAsString();
        JsonRecipeReplacementData replacementDataEntry = new JsonRecipeReplacementData(this, item, craftingType, true);
        if ("replace".equalsIgnoreCase(type)) {
            for (Map.Entry entry : jsonData.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("type") || ((String)entry.getKey()).equalsIgnoreCase("item") || ((String)entry.getKey()).equalsIgnoreCase("craftingType")) continue;
                replacementDataEntry.subProcessingData.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        } else if (!"remove".equalsIgnoreCase(type)) {
            throw new RuntimeException("Unknown replacement type '" + type + "'");
        }
        this.replacementData.add(replacementDataEntry);
        return true;
    }

    @Override
    public void loadComplete() {
        Iterator<JsonRecipeReplacementData> it = this.replacementData.iterator();
        while (it.hasNext()) {
            JsonRecipeReplacementData data = it.next();
            if (data.output == null) {
                data.output = data.convertItemEntry(data.outputValue);
            }
            if (data.output != null) continue;
            Engine.logger().error("JsonRecipeReplacementProcessor: Failed to locate item entry for '" + data.outputValue + "' ignoring value.");
            it.remove();
        }
        it = CraftingManager.func_77594_a().func_77592_b().iterator();
        block1: while (it.hasNext()) {
            JsonRecipeReplacementData r = it.next();
            if (!(r instanceof IRecipe)) continue;
            ItemStack result = ((IRecipe)r).func_77571_b();
            if (result != null) {
                for (JsonRecipeReplacementData data : this.replacementData) {
                    if (!"grid".equalsIgnoreCase(data.craftingType) || !data.doesMatchForReplacement(result)) continue;
                    Engine.logger().info("JsonRecipeReplacementProcessor: Removed recipe -> " + r);
                    it.remove();
                    continue block1;
                }
                continue;
            }
            Engine.logger().error("JsonRecipeReplacementProcessor: Potential broken recipe with no output -> " + r);
        }
        for (JsonRecipeReplacementData data : this.replacementData) {
            if (data.subProcessingData.isEmpty()) continue;
            ArrayList<IJsonGenObject> objects = new ArrayList<IJsonGenObject>();
            for (Map.Entry<String, JsonElement> entry : data.subProcessingData.entrySet()) {
                JsonContentLoader.INSTANCE.process(entry.getKey(), entry.getValue(), objects);
            }
            JsonContentLoader.INSTANCE.handlePostCalls(objects);
        }
    }
}

