/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.config;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.proxy.ContentProxy;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigRadiation
extends ContentProxy {
    public static final double MeV_per_RAD = 6.24E7;
    public static float MEV_GRAM_U238 = 4.267f;
    public static float MEV_GRAM_U235 = 4.679f;
    public static float MASS_U238_SAMPLE = 500.0f;
    public static float MASS_U235_SAMPLE = 500.0f;
    public static float ACTIVITY_U238 = 12445.0f;
    public static float ACTIVITY_U235 = 80011.0f;
    public static boolean ENABLE_EXPOSURE = true;
    public static boolean ENABLE_MAP = true;
    public static boolean ENABLE_INVENTORY = true;
    public static boolean ENABLE_ENTITY_ITEMS = true;
    public static boolean ENABLE_ENTITY = true;
    public static int RAD_REMOVE_TIMER = 6000;
    public static float RAD_REMOVE_PERCENTAGE = 0.05f;
    public static float RADIATION_DEATH_POINT = 10000.0f;
    public static float RBE_XRAY_RADIATION = 1.0f;
    public static float RBE_GAMMA_RADIATION = 1.0f;
    public static float RBE_NEURTONS_FAST = 10.0f;
    public static float RBE_NEURTONS_SLOW = 5.0f;
    public static float RBE_ALPHA_RADIATION = 20.0f;
    public static float RBE_BETA_RADIATION = 10.0f;
    public static float RAD_U235 = (float)((double)(MASS_U235_SAMPLE * MEV_GRAM_U235 * ACTIVITY_U235) / 6.24E7);
    public static float RAD_U238 = (float)((double)(MASS_U238_SAMPLE * MEV_GRAM_U238 * ACTIVITY_U238) / 6.24E7);
    public static float MAP_VALUE_TO_MILI_RAD = 0.01f;
    public static int RADIOACTIVE_MAT_VALUE_U235 = (int)Math.ceil(RAD_U235 / MAP_VALUE_TO_MILI_RAD);
    public static int RADIOACTIVE_MAT_VALUE_U238 = (int)Math.ceil(RAD_U238 / MAP_VALUE_TO_MILI_RAD);
    public static int RADIOACTIVE_MAT_VALUE_YELLOW_CAKE = RADIOACTIVE_MAT_VALUE_U235 / 10;
    public static int RADIOACTIVE_MAT_VALUE_FUEL_ROD = RADIOACTIVE_MAT_VALUE_U235 * 100;
    public static int RADIOACTIVE_MAT_VALUE_BREEDER_ROD = RADIOACTIVE_MAT_VALUE_FUEL_ROD / 10;
    public static int RADIOACTIVE_REACTOR_VALUE_FUEL_ROD = RADIOACTIVE_MAT_VALUE_FUEL_ROD * 100;
    public static int RADIOACTIVE_REACTOR_VALUE_BREEDER_ROD = RADIOACTIVE_MAT_VALUE_BREEDER_ROD * 100;
    public static int MAX_UPDATE_RANGE = 50;

    public ConfigRadiation() {
        super("config.rad");
    }

    @Override
    public void preInit() {
        Configuration configuration = new Configuration(new File(AtomicScience.configFolder, "Radiation.cfg"), "@MC@-3.0.4.20180601224130");
        configuration.load();
        ENABLE_EXPOSURE = configuration.getBoolean("enable_exposure", "general", ENABLE_EXPOSURE, "(true -> on, false -> off) Enabled event handling used to apply radiation to entities and update damage effects.");
        ENABLE_MAP = configuration.getBoolean("enable_map", "general", ENABLE_MAP, "(true -> on, false -> off) Enabled events used to update the radiation map. If disabled other radiation systems will stop working as well. However, the mod is playable as this is just related to radiation used to harm entities, machines, and items.");
        String cat_map = "rad_map";
        MAX_UPDATE_RANGE = configuration.getInt("map_update_range", "rad_map", MAX_UPDATE_RANGE, 10, 100, "Max range to update radiation values when a radiation source has changed.");
        MAP_VALUE_TO_MILI_RAD = configuration.getFloat("material_to_radiation", "rad_map", MAP_VALUE_TO_MILI_RAD, 1.0E-4f, 100.0f, "Conversation rate of material on the map to radiation values produced. Value is material -> milli-rad. Keep value low as map is limited to ~2.7 billion for values. Meaning values to large will not function.Example (good) 0.01 * 10000 = 100");
        String cat_entity = "entity";
        RAD_REMOVE_TIMER = configuration.getInt("rad_remove_timer", "entity", RAD_REMOVE_TIMER, 1, Integer.MAX_VALUE, "Amount of time in ticks (20 ticks a second) to wait before removing radiation");
        RAD_REMOVE_PERCENTAGE = configuration.getFloat("rad_remove_percentage", "entity", RAD_REMOVE_PERCENTAGE, 0.0f, 1.0f, "Percentage of radiation to remove each removal cycle");
        RADIATION_DEATH_POINT = configuration.getFloat("death_radiation_point", "entity", RADIATION_DEATH_POINT, 1.0f, 2.1474836E9f, "Amount of radiation before the player dies");
        String cat_rad_mat = "source_rad_material_values";
        configuration.setCategoryComment("source_rad_material_values", "Amount of radioactive material present inside of each source. This value is used to calculate radiation to emmit.");
        RADIOACTIVE_MAT_VALUE_U235 = configuration.getInt("U235", "source_rad_material_values", RADIOACTIVE_MAT_VALUE_U235, 1, Integer.MAX_VALUE, "Radiation material value for U235 pellet");
        RADIOACTIVE_MAT_VALUE_U238 = configuration.getInt("U238", "source_rad_material_values", RADIOACTIVE_MAT_VALUE_U238, 1, Integer.MAX_VALUE, "Radiation material value for U238 pellet");
        RADIOACTIVE_MAT_VALUE_YELLOW_CAKE = configuration.getInt("yellowcake", "source_rad_material_values", RADIOACTIVE_MAT_VALUE_YELLOW_CAKE, 1, Integer.MAX_VALUE, "Radiation material value for yellowcake");
        RADIOACTIVE_MAT_VALUE_FUEL_ROD = configuration.getInt("fuel_rod", "source_rad_material_values", RADIOACTIVE_MAT_VALUE_FUEL_ROD, 1, Integer.MAX_VALUE, "Radiation material value for fission fuel rod");
        RADIOACTIVE_MAT_VALUE_BREEDER_ROD = configuration.getInt("breeder_rod", "source_rad_material_values", RADIOACTIVE_MAT_VALUE_BREEDER_ROD, 1, Integer.MAX_VALUE, "Radiation material value for fission breeder rod");
        configuration.save();
    }
}

