/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content;

import com.builtbroken.atomic.proxy.ContentProxy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum ASFluids {
    ANTIMATTER("antimatter", false),
    STRANGE_MATTER("strange_matter", false),
    DEUTERIUM("deuterium", false),
    STEAM("steam", "steam", false),
    REACTOR_WASTE("toxic_waste", "toxic/reactor/still", "toxic/reactor/flow", false),
    LIQUID_MINERAL_WASTE("atomicscience:mineral_waste", "toxic/mineral/still", "toxic/mineral/flow", false),
    CONTAMINATED_MINERAL_WATER("atomicscience:contaminated_mineral_water", "water/mineral/still", "water/mineral/flow", false),
    CONTAMINATED_WATER("atomicscience:contaminated_water", "water/contaminated/still", "water/contaminated/flow", false),
    URANIUM_HEXAFLOURIDE("atomicscience:uranium_hexafluoride", "uranium.hexafluoride", false);

    public final String id;
    public final String texture_still;
    public final String texture_flow;
    public final boolean makeBlock;
    public Fluid fluid;

    private ASFluids(String id, boolean makeBlock) {
        this(id, null, null, makeBlock);
    }

    private ASFluids(String id, String texture, boolean makeBlock) {
        this(id, texture, texture, makeBlock);
    }

    private ASFluids(String id, String texture_still, String texture_flow, boolean makeBlock) {
        this.id = id;
        this.texture_still = texture_still;
        this.texture_flow = texture_flow;
        this.makeBlock = makeBlock;
    }

    public static class Proxy
    extends ContentProxy {
        public Proxy() {
            super("fluids");
        }

        @Override
        public void preInit() {
            for (ASFluids fluid : ASFluids.values()) {
                fluid.fluid = new Fluid(fluid.id);
                if (!fluid.id.startsWith("atomicscience:")) {
                    fluid.fluid.setUnlocalizedName("atomicscience:" + fluid.id);
                }
                if (FluidRegistry.registerFluid((Fluid)fluid.fluid)) continue;
                fluid.fluid = FluidRegistry.getFluid((String)fluid.id);
            }
        }
    }
}

