/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.effects;

import com.builtbroken.atomic.config.ConfigRadiation;
import com.builtbroken.atomic.content.ASIndirectEffects;
import com.builtbroken.atomic.content.effects.source.SourceWrapperPosition;
import com.builtbroken.atomic.lib.network.netty.PacketSystem;
import com.builtbroken.atomic.lib.network.packet.sync.PacketPlayerRadiation;
import com.builtbroken.atomic.map.MapHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class RadiationEntityEventHandler {
    public static DamageSource radiationDeathDamage = new DamageSource("radiation").func_76348_h().func_151518_m();

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        if (!event.entity.field_70170_p.field_72995_K && (entity = event.entityLiving).func_70089_S()) {
            this.applyExposure(entity);
            if (entity instanceof EntityPlayerMP) {
                this.syncPlayerData((EntityPlayerMP)entity);
            }
        }
    }

    protected void applyExposure(EntityLivingBase entity) {
        float remExposure = MapHandler.RADIATION_MAP.getRemExposure((Entity)entity);
        if (remExposure > 0.0f) {
            SourceWrapperPosition sourceWrapperPosition = new SourceWrapperPosition(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            ASIndirectEffects.applyIndirectEffect(entity, sourceWrapperPosition, remExposure);
        } else if (ASIndirectEffects.hasRadiationData((Entity)entity)) {
            NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)entity, false);
            int removeTimer = data.func_74762_e("remove_timer");
            if (removeTimer > ConfigRadiation.RAD_REMOVE_TIMER) {
                float amountToRemove = ASIndirectEffects.getRadiation((Entity)entity) * ConfigRadiation.RAD_REMOVE_PERCENTAGE;
                ASIndirectEffects.removeRadiation((Entity)entity, amountToRemove);
                data.func_74768_a("remove_timer", 0);
            } else {
                data.func_74768_a("remove_timer", removeTimer + 1);
            }
        }
        if (ASIndirectEffects.getRadiation((Entity)entity) > ConfigRadiation.RADIATION_DEATH_POINT) {
            entity.func_70097_a(radiationDeathDamage, 5.0f);
        }
    }

    protected void syncPlayerData(EntityPlayerMP player) {
        boolean sendPacket = false;
        if (ASIndirectEffects.hasRadiationData((Entity)player)) {
            NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)player, false);
            float syncError = 0.001f;
            float exposure = MapHandler.RADIATION_MAP.getRemExposure((Entity)player);
            float prev_exposure = data.func_74760_g("prev_env_rads");
            float delta_exposure = Math.abs(prev_exposure - exposure);
            float rad = data.func_74760_g("rads");
            float prev_rad = data.func_74760_g("prev_rads");
            float delta_rad = Math.abs(prev_rad - rad);
            if (delta_rad > 0.001f || delta_exposure > 0.001f || player.field_70173_aa % 20 == 0) {
                sendPacket = true;
                data.func_74776_a("prev_rads", rad);
                data.func_74776_a("prev_env_rads", exposure);
            }
        }
        if (sendPacket || player.field_70173_aa % 5 == 0) {
            RadiationEntityEventHandler.sendPacket(player);
        }
    }

    public static void sendPacket(EntityPlayerMP player) {
        NBTTagCompound data = ASIndirectEffects.getRadiationData((Entity)player, false);
        PacketSystem.INSTANCE.sendToPlayer(new PacketPlayerRadiation(data.func_74760_g("rads"), MapHandler.RADIATION_MAP.getRemExposure((Entity)player), data.func_74762_e("remove_timer")), player);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayerMP) {
            float remExposure = MapHandler.RADIATION_MAP.getRemExposure(event.entity);
            System.out.println(remExposure);
            PacketSystem.INSTANCE.sendToPlayer(new PacketPlayerRadiation(0.0f, 0.0f, 0), (EntityPlayerMP)event.entity);
        }
    }
}

