/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items;

import com.builtbroken.atomic.api.item.IFuelRodItem;
import com.builtbroken.atomic.api.reactor.IReactor;
import com.builtbroken.atomic.content.items.ItemRadioactive;
import com.builtbroken.atomic.lib.LanguageUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemFuelRod
extends ItemRadioactive
implements IFuelRodItem {
    public final int maxFuelRuntime;
    public final int reactorRadioactivity;
    public final int reactorHeatOutput;

    public ItemFuelRod(String name, String texture, int maxFuelRuntime, int radioactiveMaterialValue, int reactorRadioactivity, int reactorHeatOutput) {
        super(name, texture, radioactiveMaterialValue);
        this.maxFuelRuntime = maxFuelRuntime;
        this.reactorRadioactivity = reactorRadioactivity;
        this.reactorHeatOutput = reactorHeatOutput;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean isHeld) {
        int time = this.getFuelRodRuntime(stack, null);
        int maxTime = this.getMaxFuelRodRuntime(stack, null);
        String translation = LanguageUtility.getLocal(this.func_77658_a() + ".info.fuel");
        translation = translation.replace("%time%", "" + time);
        translation = translation.replace("%maxTime%", "" + maxTime);
        lines.add(translation);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(1.0, Math.max(0.0, 1.0 - (double)this.getFuelRodRuntime(stack, null) / (double)this.getMaxFuelRodRuntime(stack, null)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFuelRodRuntime(stack, null) != this.getMaxFuelRodRuntime(stack, null);
    }

    @Override
    public int getFuelRodRuntime(ItemStack stack, IReactor reactor) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("fuelTimer", this.getMaxFuelRodRuntime(stack, reactor));
        }
        return stack.func_77978_p().func_74762_e("fuelTimer");
    }

    @Override
    public int getMaxFuelRodRuntime(ItemStack stack, IReactor reactor) {
        return this.maxFuelRuntime;
    }

    @Override
    public int getHeatOutput(ItemStack stack, IReactor reactor) {
        return this.reactorHeatOutput;
    }

    @Override
    public int getRadioactiveMaterial(ItemStack stack, IReactor reactor) {
        return this.reactorRadioactivity;
    }

    @Override
    public ItemStack onReactorTick(IReactor reactor, ItemStack stack, int tick, int fuelTick) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("fuelTimer", Math.max(0, fuelTick - 1));
        return stack;
    }
}

