/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.armor.IAntiPoisonArmor;
import com.builtbroken.atomic.api.effect.IIndirectEffectInstance;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ItemHazmat
extends ItemArmor
implements IAntiPoisonArmor {
    public static final String ARMOR_MODEL_TEXTURE = "atomicscience:textures/models/armor/hazmat.png";
    public static final String ARMOR_TEXTURE_FOLDER = "atomicscience:armor/";
    public static ItemArmor.ArmorMaterial hazmatArmorMaterial;
    public static int damagePerTick;
    public static int damagePerAttack;

    public ItemHazmat(int slot, String type) {
        super(hazmatArmorMaterial, 0, slot);
        this.func_77637_a(AtomicScience.creativeTab);
        this.func_77655_b("atomicscience:hazmat." + type);
        this.func_111206_d("atomicscience:armor/hazmat_" + type);
        this.func_77656_e(200000);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return ARMOR_MODEL_TEXTURE;
    }

    @Override
    public boolean doesArmorProtectFromSource(ItemStack itemStack, EntityLivingBase entity, IIndirectEffectInstance instance) {
        if (this.isFullArmorSetNeeded(itemStack, entity, instance) && !this.hasFullSetOfArmor(entity)) {
            return false;
        }
        return instance.getIndirectEffectType() == AtomicScienceAPI.RADIATION;
    }

    protected boolean hasFullSetOfArmor(EntityLivingBase entity) {
        ItemStack itemStack = null;
        for (int i = 1; i < 5; ++i) {
            ItemStack slotStack = entity.func_71124_b(i);
            if (slotStack != null) {
                if (itemStack == null) {
                    itemStack = slotStack;
                    continue;
                }
                if (!(slotStack.func_77973_b() instanceof IAntiPoisonArmor) || this.isArmorPartOfSet(itemStack, slotStack)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isArmorPartOfSet(ItemStack armorStack, ItemStack compareStack) {
        return armorStack.func_77973_b() instanceof ItemHazmat && compareStack.func_77973_b() instanceof ItemHazmat;
    }

    @Override
    public void onArmorProtectFromSource(ItemStack itemStack, EntityLivingBase entityLiving, IIndirectEffectInstance instance) {
        if (instance.getIndirectEffectType() == AtomicScienceAPI.RADIATION) {
            itemStack.func_77972_a(damagePerTick, entityLiving);
        }
    }

    @Override
    public int getArmorType() {
        return this.field_77881_a;
    }

    static {
        damagePerTick = 1;
        damagePerAttack = 100;
    }
}

