/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.cell;

import com.builtbroken.atomic.AtomicScience;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidCell
extends Item
implements IFluidContainerItem {
    @SideOnly(value=Side.CLIENT)
    protected HashMap<Fluid, IIcon> fluidToIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon fluidMask;
    public HashMap<Fluid, String> supportedFluidToTexturePath = new HashMap();
    public HashMap<Fluid, String> supportedFluidToLocalization = new HashMap();
    public final int fluidCapacity;

    public ItemFluidCell(int fluidCapacity) {
        this.fluidCapacity = fluidCapacity;
        this.func_111206_d("atomicscience:cell_empty");
        this.func_77655_b("atomicscience:cell.fluid");
        this.func_77637_a(AtomicScience.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack cell, EntityPlayer player, List lines, boolean held) {
        FluidStack fluidStack = this.getFluid(cell);
        if (fluidStack != null) {
            lines.add("Fluid: " + fluidStack.getLocalizedName());
            lines.add("Amount: " + fluidStack.amount);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon icon;
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null && (icon = this.fluidToIcon.get(fluidStack.getFluid())) != null) {
            return icon;
        }
        return this.func_77618_c(stack.func_77960_j(), pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.fluidMask = reg.func_94245_a("atomicscience:cell_fluid_mask");
        this.fluidToIcon = new HashMap();
        for (Map.Entry<Fluid, String> entry : this.supportedFluidToTexturePath.entrySet()) {
            this.fluidToIcon.put(entry.getKey(), reg.func_94245_a(entry.getValue()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta == -1) {
            return this.fluidMask;
        }
        return this.field_77791_bV;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public void addSupportedFluid(Fluid fluid, String texture, String name) {
        this.supportedFluidToTexturePath.put(fluid, texture);
        this.supportedFluidToLocalization.put(fluid, name);
    }

    public String func_77667_c(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null && this.supportedFluidToLocalization.containsKey(fluidStack.getFluid())) {
            return this.supportedFluidToLocalization.get(fluidStack.getFluid());
        }
        return super.func_77658_a();
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isEmpty(stack) ? Items.field_151133_ar.getItemStackLimit(stack) : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (tab == this.func_77640_w()) {
            for (Fluid fluid : this.supportedFluidToTexturePath.keySet()) {
                list.add(this.getContainerForFluid(fluid));
            }
        }
    }

    public ItemStack getContainerForFluid(Fluid fluid) {
        ItemStack stack = new ItemStack((Item)this);
        this.fill(stack, new FluidStack(fluid, this.getCapacity(stack)), true);
        return stack;
    }

    public boolean func_77630_h(ItemStack stack) {
        return this.isEmpty(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public boolean isEmpty(ItemStack container) {
        return this.getFluid(container) == null;
    }

    public boolean isFull(ItemStack container) {
        FluidStack stack = this.getFluid(container);
        if (stack != null) {
            return stack.amount == this.getCapacity(container);
        }
        return false;
    }

    public int getCapacity(ItemStack container) {
        return this.fluidCapacity;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public boolean canSupportFluid(ItemStack container, FluidStack resource) {
        return resource != null;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (this.canSupportFluid(container, resource)) {
            if (!doFill) {
                if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
                    return Math.min(this.getCapacity(container), resource.amount);
                }
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
                if (stack == null) {
                    return Math.min(this.getCapacity(container), resource.amount);
                }
                if (!stack.isFluidEqual(resource)) {
                    return 0;
                }
                return Math.min(this.getCapacity(container) - stack.amount, resource.amount);
            }
            if (container.field_77990_d == null) {
                container.field_77990_d = new NBTTagCompound();
            }
            if (!container.field_77990_d.func_74764_b("Fluid")) {
                NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
                if (this.getCapacity(container) < resource.amount) {
                    fluidTag.func_74768_a("Amount", this.getCapacity(container));
                    container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                    return this.getCapacity(container);
                }
                container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                return resource.amount;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            int filled = this.getCapacity(container) - stack.amount;
            if (resource.amount < filled) {
                stack.amount += resource.amount;
                filled = resource.amount;
            } else {
                stack.amount = this.getCapacity(container);
            }
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.field_77990_d.func_82580_o("Fluid");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", currentAmount - stack.amount);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }
}

