/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.items.wrench;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.lib.LanguageUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class ItemWrench
extends Item {
    public static final String NBT_COLOR = "toolColor";
    public static final String NBT_MODE = "toolMode";
    @SideOnly(value=Side.CLIENT)
    private IIcon[] coloredTexture;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] texture;

    public ItemWrench() {
        this.func_77655_b("atomicscience:wrench");
        this.func_111206_d("atomicscience:wrench/wrench");
        this.func_77637_a(AtomicScience.creativeTab);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityProcessingMachine) {
                ((TileEntityProcessingMachine)tile).onWrench(this.getMode(stack), this.getColor(stack), ForgeDirection.getOrientation((int)side), player);
            }
            return true;
        }
        return false;
    }

    public void handleMouseWheelAction(ItemStack stack, EntityPlayer player, boolean ctrl, boolean forward) {
        if (ctrl) {
            this.toggleMode(stack, forward);
        } else {
            this.toggleColor(stack, forward);
        }
        player.field_71069_bz.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean held) {
        lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".mode." + this.getMode(stack).name().toLowerCase() + ".info"));
        lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".color." + this.getColor(stack).name().toLowerCase() + ".info"));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".info"));
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".ctrl.info"));
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".wheel.info"));
        } else {
            lines.add(LanguageUtility.getLocal(this.func_77658_a() + ".more.info"));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + this.getMode(stack).name().toLowerCase() + "." + this.getColor(stack).name().toLowerCase();
    }

    public void toggleMode(ItemStack stack, boolean forward) {
        this.setMode(stack, forward ? this.getMode(stack).next() : this.getMode(stack).prev());
    }

    public WrenchMode getMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return WrenchMode.get(stack.func_77978_p().func_74762_e(NBT_MODE));
        }
        return WrenchMode.ROTATION;
    }

    public void setMode(ItemStack stack, WrenchMode mode) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_MODE, mode.ordinal());
    }

    public void toggleColor(ItemStack stack, boolean forward) {
        this.setColor(stack, forward ? this.getColor(stack).next() : this.getColor(stack).prev());
    }

    public WrenchColor getColor(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return WrenchColor.get(stack.func_77978_p().func_74762_e(NBT_COLOR));
        }
        return WrenchColor.RED;
    }

    public void setColor(ItemStack stack, WrenchColor color) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_COLOR, color.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.coloredTexture = new IIcon[WrenchMode.values().length];
        this.texture = new IIcon[WrenchMode.values().length];
        for (WrenchMode mode : WrenchMode.values()) {
            this.coloredTexture[mode.ordinal()] = reg.func_94245_a(this.func_111208_A() + "." + mode.name().toLowerCase() + ".color");
            this.texture[mode.ordinal()] = reg.func_94245_a(this.func_111208_A() + "." + mode.name().toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.texture[this.getMode(stack).ordinal()];
        }
        return this.coloredTexture[this.getMode(stack).ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 0) {
            return super.func_82790_a(stack, pass);
        }
        return this.getColor(stack).getColorInt();
    }
}

