/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines;

import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.lib.gui.IPlayerUsing;
import com.builtbroken.atomic.lib.network.IPacket;
import com.builtbroken.atomic.lib.network.IPacketIDReceiver;
import com.builtbroken.atomic.lib.network.netty.PacketSystem;
import com.builtbroken.atomic.lib.network.packet.PacketTile;
import com.builtbroken.atomic.lib.transform.IPosWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityMachine
extends TileEntity
implements IPacketIDReceiver,
IPosWorld,
IPlayerUsing {
    public static final int DESC_PACKET_ID = -1;
    public static final int GUI_PACKET_ID = -2;
    private int _ticks = 0;
    private boolean _syncClientNextTick = true;
    private ArrayList<EntityPlayer> playersUsingGUI = new ArrayList();

    public final void func_145845_h() {
        if (this._ticks == 0) {
            this.firstTick();
        }
        this.update(this._ticks);
        ++this._ticks;
        if (this._ticks + 1 == Integer.MAX_VALUE) {
            this._ticks = 1;
        }
        if (this.isServer() && this._ticks % 3 == 0 && this instanceof IGuiTile) {
            Iterator<EntityPlayer> it = this.playersUsingGUI.iterator();
            while (it.hasNext()) {
                EntityPlayer player = it.next();
                if (player instanceof EntityPlayerMP && this.shouldSendGuiPacket((EntityPlayerMP)player)) {
                    PacketTile packet = new PacketTile("gui", -2, this);
                    ArrayList<Object> objects = new ArrayList<Object>();
                    this.writeGuiPacket(objects, player);
                    packet.addData(objects);
                    PacketSystem.INSTANCE.sendToPlayer(packet, (EntityPlayerMP)player);
                    continue;
                }
                it.remove();
            }
        }
        if (this._syncClientNextTick) {
            this._syncClientNextTick = false;
            this.sendDescPacket();
        }
    }

    protected void firstTick() {
    }

    protected void update(int ticks) {
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (this.isClient()) {
            if (id == -1) {
                this.readDescPacket(buf, player);
                return true;
            }
            if (id == -2) {
                this.readGuiPacket(buf, player);
                return true;
            }
        }
        return false;
    }

    protected void syncClientNextTick() {
        this._syncClientNextTick = true;
    }

    protected void sendDescPacket() {
        PacketTile packetTile = new PacketTile("reactor_desc", -1, this);
        ArrayList<Object> list = new ArrayList<Object>();
        this.writeDescPacket(list, null);
        packetTile.addData(list);
        PacketSystem.INSTANCE.sendToAllAround((IPacket)packetTile, this);
    }

    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
    }

    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
    }

    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
    }

    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
    }

    protected boolean isServer() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K;
    }

    protected boolean isClient() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K;
    }

    @Override
    public Collection<EntityPlayer> getPlayersUsingGui() {
        return this.playersUsingGUI;
    }

    protected boolean shouldSendGuiPacket(EntityPlayerMP playerMP) {
        return playerMP.func_70089_S() && playerMP.field_71070_bA != null;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public double z() {
        return (double)this.field_145849_e + 0.5;
    }

    @Override
    public double x() {
        return (double)this.field_145851_c + 0.5;
    }

    @Override
    public double y() {
        return (double)this.field_145848_d + 0.5;
    }

    @Override
    public int zi() {
        return this.field_145849_e;
    }

    @Override
    public int xi() {
        return this.field_145851_c;
    }

    @Override
    public int yi() {
        return this.field_145848_d;
    }
}

