/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines;

import com.builtbroken.atomic.content.machines.TileEntityInventoryMachine;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public abstract class TileEntityPowerInvMachine
extends TileEntityInventoryMachine {
    private int energyStored;

    public int addEnergy(int energy, boolean doAction) {
        int room = this.getMaxEnergyStored() - this.getEnergyStored();
        if (room >= energy) {
            if (doAction) {
                this.energyStored += energy;
            }
            return energy;
        }
        if (doAction) {
            this.energyStored += room;
        }
        return room;
    }

    protected boolean checkEnergyExtract() {
        return this.getEnergyStored() >= this.getEnergyUsage();
    }

    protected void extractEnergy() {
        this.energyStored = Math.max(0, this.energyStored - this.getEnergyUsage());
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyUsage() * 10;
    }

    public abstract int getEnergyUsage();

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.energyStored);
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        this.energyStored = buf.readInt();
    }
}

