/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.power;

import com.builtbroken.atomic.content.machines.TileEntityPowerInvMachine;
import com.builtbroken.atomic.content.machines.power.TileEntityPowerBus;
import java.util.ArrayList;
import java.util.List;

public class PowerBusNetwork {
    private List<TileEntityPowerInvMachine> outputs = new ArrayList<TileEntityPowerInvMachine>();
    private List<TileEntityPowerBus> wires = new ArrayList<TileEntityPowerBus>();

    public int addEnergy(int energy, boolean doAction) {
        if (this.outputs.size() > 0) {
            int energyLeft = energy;
            int tiles = this.outputs.size();
            for (TileEntityPowerInvMachine machine : this.outputs) {
                if (machine.func_145837_r()) continue;
                int energyToGive = energyLeft / tiles + energyLeft % tiles;
                energyLeft -= machine.addEnergy(energyToGive, doAction);
            }
            return energy - energyLeft;
        }
        return 0;
    }

    public void merge(PowerBusNetwork other) {
        if (other != this) {
            this.wires.addAll(other.wires);
            other.destroy();
            this.refresh();
        }
    }

    public void destroy() {
        this.wires.forEach(wire -> wire.setNetwork(null));
        this.outputs.clear();
        this.wires.clear();
    }

    protected void refresh() {
        this.wires.forEach(wire -> wire.setNetwork(this));
        this.outputs.clear();
        for (TileEntityPowerBus bus : this.wires) {
            bus.checkConnections(true);
        }
    }

    protected void addConnection(TileEntityPowerInvMachine machine) {
        if (!this.outputs.contains(machine)) {
            this.outputs.add(machine);
        }
    }

    public void removeConnection(TileEntityPowerInvMachine oldConnection) {
        this.outputs.remove(oldConnection);
    }

    public void addWire(TileEntityPowerBus wire) {
        wire.setNetwork(this);
    }
}

