/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.power;

import com.builtbroken.atomic.content.machines.TileEntityMachine;
import com.builtbroken.atomic.content.machines.TileEntityPowerInvMachine;
import com.builtbroken.atomic.content.machines.power.PowerBusNetwork;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPowerBus
extends TileEntityMachine {
    private PowerBusNetwork powerNetwork;
    private TileEntityPowerInvMachine[] connections = new TileEntityPowerInvMachine[6];

    public void setNetwork(PowerBusNetwork network) {
        this.powerNetwork = network;
    }

    @Override
    protected void firstTick() {
        super.firstTick();
        this.checkForWires();
        this.checkConnections(false);
    }

    @Override
    public void update(int ticks) {
        super.update(ticks);
        if (ticks % 20 == 0) {
            this.checkConnections(false);
        }
    }

    protected void checkConnections(boolean clear) {
        TileEntityPowerInvMachine[] newConnections = new TileEntityPowerInvMachine[6];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int x = this.field_145851_c + direction.offsetX;
            int y = this.field_145848_d + direction.offsetY;
            int z = this.field_145849_e + direction.offsetZ;
            TileEntity tile = this.world().func_147438_o(x, y, z);
            if (!(tile instanceof TileEntityPowerInvMachine)) continue;
            newConnections[direction.ordinal()] = (TileEntityPowerInvMachine)tile;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntityPowerInvMachine newConnection = newConnections[i];
            if (!clear) {
                TileEntityPowerInvMachine oldConnection = this.getConnections()[i];
                if (newConnection != oldConnection) {
                    if (oldConnection != null) {
                        this.getPowerNetwork().removeConnection(oldConnection);
                    }
                    if (newConnection != null) {
                        this.getPowerNetwork().addConnection(newConnection);
                    }
                }
            } else if (newConnection != null) {
                this.getPowerNetwork().addConnection(newConnection);
            }
            this.getConnections()[i] = newConnection;
        }
    }

    protected void checkForWires() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int x = this.field_145851_c + direction.offsetX;
            int y = this.field_145848_d + direction.offsetY;
            int z = this.field_145849_e + direction.offsetZ;
            TileEntity tile = this.world().func_147438_o(x, y, z);
            if (!(tile instanceof TileEntityPowerBus)) continue;
            if (this.powerNetwork == null) {
                ((TileEntityPowerBus)tile).getPowerNetwork().addWire(this);
                continue;
            }
            this.getPowerNetwork().merge(((TileEntityPowerBus)tile).getPowerNetwork());
        }
    }

    public PowerBusNetwork getPowerNetwork() {
        if (this.powerNetwork == null) {
            this.powerNetwork = new PowerBusNetwork();
            this.powerNetwork.addWire(this);
        }
        return this.powerNetwork;
    }

    public TileEntityPowerInvMachine[] getConnections() {
        return this.connections;
    }
}

