/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing;

import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.TileEntityPowerInvMachine;
import com.builtbroken.atomic.content.machines.processing.recipes.ProcessingRecipe;
import com.builtbroken.atomic.content.machines.processing.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.lib.power.PowerSystem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityProcessingMachine
extends TileEntityPowerInvMachine {
    boolean processing = false;
    public int processTimer = 0;
    ForgeDirection _facingDirectionCache;
    float _processingAnimationRotationPrev = 0.0f;
    float _processingAnimationRotation = 0.0f;

    @Override
    public void update(int ticks) {
        super.update(ticks);
        if (this.isServer()) {
            this.preProcess(ticks);
            this.process(ticks);
            this.postProcess(ticks);
        } else if (this.processTimer > 0) {
            this.doAnimation(ticks);
            this.doEffects(ticks);
        }
    }

    protected void doAnimation(int ticks) {
        this._processingAnimationRotation += 5.0f;
        if (this._processingAnimationRotation > 360.0f) {
            this._processingAnimationRotation -= 360.0f;
            this._processingAnimationRotationPrev -= 360.0f;
        }
    }

    protected void doEffects(int ticks) {
    }

    public void onWrench(WrenchMode type, WrenchColor color, ForgeDirection side, EntityPlayer player) {
    }

    protected void preProcess(int ticks) {
    }

    protected void process(int ticks) {
        if (this.processing) {
            if (this.processTimer++ >= this.getProcessingTime()) {
                this.processTimer = 0;
                this.doProcess();
                this.checkRecipe();
            }
        } else if (ticks % 20 == 0) {
            this.checkRecipe();
        }
    }

    protected void onProcessed() {
    }

    protected abstract int getProcessingTime();

    protected void doProcess() {
        ProcessingRecipe<TileEntityProcessingMachine> recipe = this.getRecipeList().getMatchingRecipe(this);
        if (recipe != null && recipe.applyRecipe(this)) {
            this.onProcessed();
        }
    }

    protected void checkRecipe() {
        this.processing = this.canProcess();
        if (!this.processing) {
            this.processTimer = 0;
        } else if (this.processTimer == 0) {
            this.processTimer = 1;
        }
        this.syncClientNextTick();
    }

    protected boolean canProcess() {
        return this.getRecipeList().getMatchingRecipe(this) != null;
    }

    protected abstract ProcessingRecipeList getRecipeList();

    protected void postProcess(int ticks) {
    }

    protected void drainBattery(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        int power = PowerSystem.getEnergyStored(itemStack);
        if (power > 0) {
            power = PowerSystem.removePower(itemStack, power, false);
            int added = this.addEnergy(power, true);
            PowerSystem.removePower(itemStack, added, true);
            this.func_70299_a(slot, itemStack);
        }
    }

    public boolean hasSpaceInOutput(ItemStack insertStack, int slot) {
        if (insertStack != null) {
            ItemStack stackInSlot = this.func_70301_a(slot);
            if (stackInSlot == null) {
                return true;
            }
            if (stackInSlot.func_77973_b() == insertStack.func_77973_b() && stackInSlot.func_77960_j() == insertStack.func_77960_j()) {
                return this.func_70297_j_() - stackInSlot.field_77994_a >= insertStack.field_77994_a;
            }
        }
        return false;
    }

    public void addToOutput(ItemStack insertStack, int slot) {
        ItemStack stackInSlot = this.func_70301_a(slot);
        if (stackInSlot == null) {
            this.func_70299_a(slot, insertStack);
        } else if (stackInSlot.func_77973_b() == insertStack.func_77973_b() && stackInSlot.func_77960_j() == insertStack.func_77960_j()) {
            stackInSlot.field_77994_a += insertStack.field_77994_a;
            stackInSlot.field_77994_a = Math.min(stackInSlot.field_77994_a, stackInSlot.func_77976_d());
            stackInSlot.field_77994_a = Math.min(stackInSlot.field_77994_a, this.func_70297_j_());
        }
    }

    protected boolean containsFluid(int slot) {
        return this.getFluid(slot) != null;
    }

    protected boolean containsFluid(int slot, Fluid fluid) {
        FluidStack fluidStack = this.getFluid(slot);
        if (fluidStack != null) {
            return fluidStack.getFluid() == fluid;
        }
        return false;
    }

    protected boolean isInputFluid(int slot) {
        return this.isInputFluid(this.func_70301_a(slot));
    }

    protected boolean isInputFluid(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            return this.getRecipeList().isComponent(this, fluidStack.getFluid());
        }
        return false;
    }

    protected FluidStack getFluid(int slot) {
        return this.getFluid(this.func_70301_a(slot));
    }

    protected FluidStack getFluid(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
            }
        }
        return null;
    }

    protected boolean isEmptyFluidContainer(int slot) {
        return this.isEmptyFluidContainer(this.func_70301_a(slot));
    }

    protected boolean isEmptyFluidContainer(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack) == null;
            }
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack) || itemStack.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    protected void fillTank(int slot, IFluidTank inputTank) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            FluidStack stack;
            if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem fluidContainerItem = (IFluidContainerItem)itemStack.func_77973_b();
                FluidStack fluidStack = fluidContainerItem.getFluid(itemStack);
                if (fluidStack != null && this.getRecipeList().isComponent(this, fluidStack.getFluid())) {
                    fluidStack = fluidContainerItem.drain(itemStack, inputTank.getCapacity() - inputTank.getFluidAmount(), false);
                    int amount = inputTank.fill(fluidStack, true);
                    fluidContainerItem.drain(itemStack, amount, true);
                    this.func_70299_a(slot, itemStack);
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack) && (stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack)) != null && this.getRecipeList().isComponent(this, stack.getFluid())) {
                inputTank.fill(stack, true);
                this.func_70298_a(slot, 1);
                ItemStack container = itemStack.func_77973_b().getContainerItem(itemStack);
                if (container != null) {
                    if (this.func_70301_a(slot) == null) {
                        this.func_70299_a(slot, container);
                    } else {
                        EntityItem item = new EntityItem(this.field_145850_b);
                        item.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                        item.func_92058_a(container);
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
            }
        }
    }

    protected void outputFluids(int slot, IFluidTank outputTank) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null && outputTank.getFluid() != null) {
            FluidStack fluidStack;
            ItemStack filledContainer;
            if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
                ItemStack fluidContainer = itemStack.func_77946_l();
                fluidContainer.field_77994_a = 1;
                IFluidContainerItem fluidContainerItem = (IFluidContainerItem)fluidContainer.func_77973_b();
                FluidStack fluidStack2 = fluidContainerItem.getFluid(fluidContainer);
                if (fluidStack2 == null || fluidStack2.getFluid() == outputTank.getFluid().getFluid()) {
                    int filled = fluidContainerItem.fill(fluidContainer, outputTank.getFluid(), true);
                    outputTank.drain(filled, true);
                    if (itemStack.field_77994_a == 1) {
                        this.func_70299_a(slot, fluidContainer);
                    } else {
                        this.func_70298_a(slot, 1);
                        EntityItem item = new EntityItem(this.field_145850_b);
                        item.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                        item.func_92058_a(fluidContainer);
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack) && (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)outputTank.getFluid(), (ItemStack)itemStack)) != null && (fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer)).getFluid() == outputTank.getFluid().getFluid() && fluidStack.amount <= outputTank.getFluidAmount()) {
                outputTank.drain(fluidStack.amount, true);
                this.func_70298_a(slot, 1);
                if (this.func_70301_a(slot) == null) {
                    this.func_70299_a(slot, filledContainer);
                } else {
                    EntityItem item = new EntityItem(this.field_145850_b);
                    item.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    item.func_92058_a(filledContainer);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
            }
        }
    }

    protected void outputFluidToTiles(IFluidTank outputTank, Function<ForgeDirection, Boolean> canUseSideFunction) {
        if (outputTank.getFluid() != null) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile;
                int z;
                int y;
                int x;
                if (canUseSideFunction != null && !canUseSideFunction.apply(direction).booleanValue() || !this.field_145850_b.func_72899_e(x = this.field_145851_c + direction.offsetX, y = this.field_145848_d + direction.offsetY, z = this.field_145849_e + direction.offsetZ) || !((tile = this.field_145850_b.func_147438_o(x, y, z)) instanceof IFluidHandler) || outputTank.getFluid() == null || !((IFluidHandler)tile).canFill(direction.getOpposite(), outputTank.getFluid().getFluid())) continue;
                int fill = ((IFluidHandler)tile).fill(direction.getOpposite(), outputTank.getFluid(), true);
                outputTank.drain(fill, true);
            }
        }
    }

    public boolean hasInputFluid(IFluidTank tank, Fluid fluid, int amount) {
        FluidStack inputFluidStack = tank.getFluid();
        return inputFluidStack != null && inputFluidStack.getFluid() == fluid && inputFluidStack.amount >= amount;
    }

    public boolean canOutputFluid(IFluidTank tank, Fluid fluid, int amount) {
        if (fluid != null && amount > 0) {
            if (tank.getFluid() != null) {
                int room = tank.getCapacity() - tank.getFluid().amount;
                return room >= amount && fluid == tank.getFluid().getFluid();
            }
            return tank.getCapacity() >= amount;
        }
        return false;
    }

    public boolean tankMatch(IFluidTank tank, FluidStack fluidStack) {
        if (fluidStack != null) {
            return tank.getFluid() != null && tank.getFluid().getFluid() == fluidStack.getFluid();
        }
        return false;
    }

    public boolean tankMatch(IFluidTank tank, Fluid fluid) {
        return tank.getFluid() != null && tank.getFluid().getFluid() == fluid;
    }

    public ForgeDirection getFacingDirection() {
        if (this._facingDirectionCache == null) {
            this._facingDirectionCache = ForgeDirection.getOrientation((int)this.func_145832_p());
        }
        return this._facingDirectionCache;
    }

    public void func_70296_d() {
        if (this.isServer()) {
            this._facingDirectionCache = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float rotate(float delta) {
        this._processingAnimationRotationPrev = this._processingAnimationRotation + (this._processingAnimationRotation - this._processingAnimationRotationPrev) * delta;
        return this._processingAnimationRotationPrev;
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.processTimer);
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.processTimer = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("processingProgress", this.processTimer);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTimer = nbt.func_74762_e("processingProgress");
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.processTimer);
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.processTimer = buf.readInt();
    }
}

