/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing.boiler;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.machines.processing.boiler.gui.ContainerChemBoiler;
import com.builtbroken.atomic.content.machines.processing.boiler.gui.GuiChemBoiler;
import com.builtbroken.atomic.content.machines.processing.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.lib.SideSettings;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.lib.network.netty.PacketSystem;
import com.builtbroken.atomic.lib.network.packet.client.PacketSpawnParticle;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityChemBoiler
extends TileEntityProcessingMachine
implements IFluidHandler,
IGuiTile,
ISidedInventory {
    public static final int SLOT_FLUID_INPUT = 0;
    public static final int SLOT_ITEM_INPUT = 1;
    public static final int SLOT_ITEM_OUTPUT = 2;
    public static final int SLOT_BATTERY = 3;
    public static final int SLOT_WASTE_FLUID = 4;
    public static final int SLOT_HEX_FLUID = 5;
    public static final int INVENTORY_SIZE = 6;
    public static final int[] INPUT_SLOTS = new int[]{1};
    public static final int[] OUTPUT_SLOTS = new int[]{2};
    public static final int[] ACCESSIBLE_SLOTS = new int[]{1, 2};
    public static int PROCESSING_TIME = 100;
    public static int ENERGY_PER_TICK = 100;
    private final FluidTank blueTank;
    private final FluidTank greenTank;
    private final FluidTank yellowTank;
    private final SideSettings blueTankSideSettings = new SideSettings(true);
    private final SideSettings greenTankSideSettings = new SideSettings(false);
    private final SideSettings yellowTankSideSettings = new SideSettings(false);

    public TileEntityChemBoiler() {
        this.blueTank = new FluidTank(10000);
        this.greenTank = new FluidTank(10000);
        this.yellowTank = new FluidTank(10000);
    }

    @Override
    protected void onProcessed() {
        if (this.isServer()) {
            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(this.field_145850_b.field_73011_w.field_76574_g, (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0, "boiler:complete");
            PacketSystem.INSTANCE.sendToAllAround(packetSpawnParticle, this.field_145850_b, this, 30.0);
        }
    }

    @Override
    protected void doEffects(int ticks) {
        if ((double)this.field_145850_b.field_73012_v.nextFloat() > 0.3) {
            AtomicScience.sideProxy.spawnParticle("boiler:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void preProcess(int ticks) {
        this.fillTank(0, (IFluidTank)this.getBlueTank());
        this.drainBattery(3);
    }

    @Override
    protected int getProcessingTime() {
        return PROCESSING_TIME;
    }

    @Override
    protected void postProcess(int ticks) {
        this.outputFluids(4, (IFluidTank)this.getGreenTank());
        this.outputFluids(5, (IFluidTank)this.getYellowTank());
        this.outputFluidToTiles((IFluidTank)this.getGreenTank(), f -> this.greenTankSideSettings.get((ForgeDirection)f));
        this.outputFluidToTiles((IFluidTank)this.getYellowTank(), f -> this.yellowTankSideSettings.get((ForgeDirection)f));
    }

    @Override
    protected ProcessingRecipeList getRecipeList() {
        return ProcessorRecipeHandler.INSTANCE.chemBoilerProcessingRecipe;
    }

    @Override
    protected void onSlotStackChanged(ItemStack prev, ItemStack stack, int slot) {
        if (this.isServer() && slot == 1) {
            this.checkRecipe();
        }
        super.onSlotStackChanged(prev, stack, slot);
    }

    @Override
    public void onWrench(WrenchMode type, WrenchColor color, ForgeDirection side, EntityPlayer player) {
        if (type == WrenchMode.FLUID && side != ForgeDirection.UNKNOWN) {
            if (color == WrenchColor.GREEN) {
                this.greenTankSideSettings.toggle(side);
                player.func_146105_b((IChatComponent)new ChatComponentText(this.greenTankSideSettings.get(side) ? "Green tank set to output on side" : "Green tank set to ignore side"));
            } else if (color == WrenchColor.YELLOW) {
                this.yellowTankSideSettings.toggle(side);
                player.func_146105_b((IChatComponent)new ChatComponentText(this.yellowTankSideSettings.get(side) ? "Yellow tank set to output on side" : "Yellow tank set to ignore side"));
            } else if (color == WrenchColor.BLUE) {
                this.blueTankSideSettings.toggle(side);
                player.func_146105_b((IChatComponent)new ChatComponentText(this.blueTankSideSettings.get(side) ? "Blue tank set to input on side" : "Blue tank set to ignore side"));
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            Fluid fluid = this.getBlueTank().getFluid() != null ? this.getBlueTank().getFluid().getFluid() : null;
            int amount = this.getBlueTank().getFluidAmount();
            int fill = this.getBlueTank().fill(resource, doFill);
            if (doFill && this.getBlueTank().getFluid() != null && (this.tankMatch((IFluidTank)this.getBlueTank(), fluid) || this.getBlueTank().getFluidAmount() != amount)) {
                this.checkRecipe();
            }
            return fill;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tankMatch((IFluidTank)this.getGreenTank(), resource)) {
            return this.getGreenTank().drain(resource.amount, doDrain);
        }
        if (this.tankMatch((IFluidTank)this.getYellowTank(), resource)) {
            return this.getYellowTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack stack = this.getGreenTank().drain(maxDrain, doDrain);
        if (stack == null) {
            return this.getYellowTank().drain(maxDrain, doDrain);
        }
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.blueTankSideSettings.get(from) && this.getRecipeList().isComponent(this, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null && this.greenTankSideSettings.get(from) && this.yellowTankSideSettings.get(from) || this.greenTankSideSettings.get(from) && this.tankMatch((IFluidTank)this.getGreenTank(), fluid) || this.yellowTankSideSettings.get(from) && this.tankMatch((IFluidTank)this.getYellowTank(), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getBlueTank().getInfo(), this.getGreenTank().getInfo(), this.getYellowTank().getInfo()};
    }

    public FluidTank getBlueTank() {
        return this.blueTank;
    }

    public FluidTank getGreenTank() {
        return this.greenTank;
    }

    public FluidTank getYellowTank() {
        return this.yellowTank;
    }

    @Override
    public int getEnergyUsage() {
        return ENERGY_PER_TICK;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerChemBoiler(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiChemBoiler(player, this);
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.getBlueTank());
        dataList.add(this.getGreenTank());
        dataList.add(this.getYellowTank());
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.getBlueTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getGreenTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getYellowTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("wasteTank", (NBTBase)this.getGreenTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("inputTank", (NBTBase)this.getBlueTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("hexTank", (NBTBase)this.getYellowTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("wasteTankSides", (NBTBase)this.greenTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("hexTankSides", (NBTBase)this.yellowTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("waterTankSides", (NBTBase)this.blueTankSideSettings.save(new NBTTagCompound()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getGreenTank().readFromNBT(nbt.func_74775_l("wasteTank"));
        this.getBlueTank().readFromNBT(nbt.func_74775_l("inputTank"));
        this.getYellowTank().readFromNBT(nbt.func_74775_l("hexTank"));
        this.greenTankSideSettings.load(nbt.func_74775_l("wasteTankSides"));
        this.yellowTankSideSettings.load(nbt.func_74775_l("hexTankSides"));
        this.blueTankSideSettings.load(nbt.func_74775_l("waterTankSides"));
    }

    public int func_70302_i_() {
        return 6;
    }

    public int[] func_94128_d(int side) {
        return ACCESSIBLE_SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.isInputFluid(stack);
        }
        if (slot == 5) {
            return this.isEmptyFluidContainer(stack);
        }
        if (slot == 4) {
            return this.isEmptyFluidContainer(stack);
        }
        if (slot == 1) {
            return this.getRecipeList().isComponent(this, stack);
        }
        return false;
    }
}

