/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing.centrifuge;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.ASFluids;
import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.machines.processing.centrifuge.gui.ContainerChemCentrifuge;
import com.builtbroken.atomic.content.machines.processing.centrifuge.gui.GuiChemCentrifuge;
import com.builtbroken.atomic.content.machines.processing.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.lib.SideSettings;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.lib.network.netty.PacketSystem;
import com.builtbroken.atomic.lib.network.packet.client.PacketSpawnParticle;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityChemCentrifuge
extends TileEntityProcessingMachine
implements IFluidHandler,
IGuiTile,
ISidedInventory {
    public static final int SLOT_FLUID_INPUT = 0;
    public static final int SLOT_ITEM_OUTPUT = 1;
    public static final int SLOT_BATTERY = 2;
    public static final int SLOT_FLUID_OUTPUT = 3;
    public static final int INVENTORY_SIZE = 4;
    public static final int[] ACCESSIBLE_SIDES = new int[]{1};
    public static int PROCESSING_TIME = 100;
    public static int ENERGY_PER_TICK = 100;
    private final FluidTank inputTank;
    private final FluidTank outputTank;
    private final SideSettings inputTankSideSettings = new SideSettings(true);
    private final SideSettings outputTankSideSettings = new SideSettings(false);

    public TileEntityChemCentrifuge() {
        this.inputTank = new FluidTank(10000);
        this.outputTank = new FluidTank(10000);
    }

    @Override
    protected void onProcessed() {
        if (this.isServer()) {
            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(this.field_145850_b.field_73011_w.field_76574_g, (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0, "centrifuge:complete");
            PacketSystem.INSTANCE.sendToAllAround(packetSpawnParticle, this.field_145850_b, this, 30.0);
        }
    }

    @Override
    protected void doEffects(int ticks) {
        if ((double)this.field_145850_b.field_73012_v.nextFloat() > 0.4) {
            AtomicScience.sideProxy.spawnParticle("centrifuge:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void preProcess(int ticks) {
        this.fillTank(0, (IFluidTank)this.getInputTank());
        this.drainBattery(2);
    }

    @Override
    protected int getProcessingTime() {
        return PROCESSING_TIME;
    }

    @Override
    protected void postProcess(int ticks) {
        this.outputFluids(3, (IFluidTank)this.getOutputTank());
        this.outputFluidToTiles((IFluidTank)this.getOutputTank(), null);
    }

    @Override
    protected ProcessingRecipeList getRecipeList() {
        return ProcessorRecipeHandler.INSTANCE.chemCentrifugeProcessingRecipe;
    }

    @Override
    public void onWrench(WrenchMode type, WrenchColor color, ForgeDirection side, EntityPlayer player) {
        if (type == WrenchMode.FLUID && side != ForgeDirection.UNKNOWN) {
            if (color == WrenchColor.GREEN) {
                this.outputTankSideSettings.toggle(side);
                player.func_146105_b((IChatComponent)new ChatComponentText(this.outputTankSideSettings.get(side) ? "Green tank set to output on side" : "Green tank set to ignore side"));
            } else if (color == WrenchColor.BLUE) {
                this.inputTankSideSettings.toggle(side);
                player.func_146105_b((IChatComponent)new ChatComponentText(this.inputTankSideSettings.get(side) ? "Blue tank set to input on side" : "Blue tank set to ignore side"));
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            Fluid fluid = this.getInputTank().getFluid() != null ? this.getInputTank().getFluid().getFluid() : null;
            int amount = this.getInputTank().getFluidAmount();
            int fill = this.getInputTank().fill(resource, doFill);
            if (doFill && this.getInputTank().getFluid() != null && fluid != this.getInputTank().getFluid().getFluid() || this.getInputTank().getFluidAmount() != amount) {
                this.checkRecipe();
            }
            return fill;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.getOutputTank().getFluid() != null && resource.getFluid() == this.getOutputTank().getFluid().getFluid()) {
            return this.getOutputTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getOutputTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == ASFluids.CONTAMINATED_MINERAL_WATER.fluid || fluid == ASFluids.URANIUM_HEXAFLOURIDE.fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || this.getOutputTank().getFluid() != null && this.getOutputTank().getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInputTank().getInfo(), this.getOutputTank().getInfo()};
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public int getEnergyUsage() {
        return ENERGY_PER_TICK;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerChemCentrifuge(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiChemCentrifuge(player, this);
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.getInputTank());
        dataList.add(this.getOutputTank());
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.getInputTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getOutputTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("outputTank", (NBTBase)this.getOutputTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("inputTank", (NBTBase)this.getInputTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("outputTankSides", (NBTBase)this.outputTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("inputTankSides", (NBTBase)this.inputTankSideSettings.save(new NBTTagCompound()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getOutputTank().readFromNBT(nbt.func_74775_l("outputTank"));
        this.getInputTank().readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTankSideSettings.load(nbt.func_74775_l("outputTankSides"));
        this.inputTankSideSettings.load(nbt.func_74775_l("inputTankSides"));
    }

    public int func_70302_i_() {
        return 4;
    }

    public int[] func_94128_d(int side) {
        return ACCESSIBLE_SIDES;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.isInputFluid(stack);
        }
        if (slot == 3) {
            return this.isEmptyFluidContainer(stack);
        }
        return false;
    }
}

