/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing.extractor.recipe;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.machines.processing.recipes.RecipeLootTable;
import com.builtbroken.atomic.content.machines.processing.recipes.RecipeRandomItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class DustLootTable
extends RecipeLootTable {
    public static final DustLootTable INSTANCE = new DustLootTable();
    public final int defaultDustWeight = 10;
    public final int defaultRareDustWeight = 20;
    private final HashMap<String, List<RecipeRandomItem>> dustEntries = new HashMap();
    private final HashMap<String, Integer> dustWeights = new HashMap();

    private DustLootTable() {
        super("chem.extractor.loot.table.dust");
        this.dustWeights.put("dustCopper", 5);
        this.dustWeights.put("dustTin", 5);
        this.dustWeights.put("dustIron", 5);
        this.dustWeights.put("dustLead", 8);
        this.dustWeights.put("dustGold", 15);
        this.dustWeights.put("dustNickel", 8);
        this.dustWeights.put("dustPlatinum", 18);
        this.dustWeights.put("dustSteel", -1);
        this.dustWeights.put("dustBronze", -1);
        this.dustWeights.put("dustElectrum", -1);
        this.dustWeights.put("dustInvar", -1);
        this.dustWeights.put("dustLumium", -1);
        this.dustWeights.put("dustMithril", -1);
        this.dustWeights.put("dustSignalm", -1);
    }

    @Override
    public void loadComplete() {
        this.lootItems.clear();
        this.lootItems.add(new RecipeRandomItem(20, new ItemStack(Items.field_151137_ax)));
        this.lootItems.add(new RecipeRandomItem(20, new ItemStack(Items.field_151114_aO)));
        this.addEntries("stoneDust", 1, i -> true);
        for (String ore_name : OreDictionary.getOreNames()) {
            if (!ore_name.toLowerCase().contains("dust") || this.name.toLowerCase().equalsIgnoreCase("stoneDust")) continue;
            this.addEntries(ore_name, 10, item -> this.hasIngot((ItemStack)item));
        }
        this.loadConfiguration();
        Collections.sort(this.lootItems, Comparator.comparingInt(o -> -o.weight));
    }

    @Override
    public void loadConfiguration() {
        this.dustEntries.keySet().forEach(key -> {
            if (!this.dustWeights.containsKey(key)) {
                this.dustWeights.put((String)key, this.dustEntries.get((Object)key).get((int)0).weight);
            }
        });
        Configuration configuration = new Configuration(new File(AtomicScience.configFolder, "DustLootTable.cfg"), "@MC@-3.0.4.20180601224130");
        configuration.load();
        configuration.setCategoryComment("loot_weights", "Weight in the loot table, higher the number lower the chance of dropping. Zero and lower will disable the entry.");
        for (String dust_name : this.dustEntries.keySet()) {
            int weight = configuration.getInt(dust_name, "loot_weights", this.dustWeights.get(dust_name).intValue(), -1, Short.MAX_VALUE, "");
            this.dustWeights.put(dust_name, weight);
        }
        configuration.save();
        this.calculateTotalWeight();
    }

    @Override
    protected void addEntry(String ore_name, ItemStack dustStack, int weight) {
        ItemStack stack1 = dustStack.func_77946_l();
        stack1.field_77994_a = 1;
        RecipeRandomItem recipeRandomItem = new RecipeRandomItem(weight, stack1);
        this.lootItems.add(recipeRandomItem);
        if (!this.dustEntries.containsKey(ore_name)) {
            this.dustEntries.put(ore_name, new ArrayList());
        }
        this.dustEntries.get(ore_name).add(recipeRandomItem);
    }
}

