/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.reactor.fission;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.item.IFuelRodItem;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.api.reactor.IFissionReactor;
import com.builtbroken.atomic.content.ASBlocks;
import com.builtbroken.atomic.content.machines.TileEntityInventoryMachine;
import com.builtbroken.atomic.map.MapHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileEntityReactorCell
extends TileEntityInventoryMachine
implements IFissionReactor,
IRadiationSource,
ISidedInventory {
    public static final int SLOT_FUEL_ROD = 0;
    public static final int[] ACCESSIBLE_SIDES = new int[]{0};
    private boolean _running = false;
    private boolean _renderFuel = false;
    private float _renderFuelLevel = 0.0f;
    public StructureType structureType;

    @Override
    protected void firstTick() {
        super.firstTick();
        this.updateStructureType();
        MapHandler.RADIATION_MAP.addSource(this);
        MapHandler.THERMAL_MAP.addSource(this);
    }

    @Override
    public void update(int ticks) {
        super.update(ticks);
        if (this.isServer()) {
            TileEntity tile;
            boolean prev_running = this._running;
            if (this.canOperate()) {
                this._running = true;
                this.consumeFuel(ticks);
                if (ticks % 20 == 0) {
                    this.doOperationTick();
                }
            } else {
                this._running = false;
            }
            if (prev_running != this._running || ticks % 20 == 0) {
                this.syncClientNextTick();
            }
            if (ticks % 100 == 0 && this.getFuelRod() != null && (tile = this.field_145850_b.func_147438_o(this.xi(), this.yi() - 1, this.zi())) instanceof TileEntityReactorCell) {
                if (((TileEntityReactorCell)tile).getFuelRod() != null) {
                    int otherRunTime;
                    int runTime = this.getFuelRuntime();
                    if (runTime < (otherRunTime = ((TileEntityReactorCell)tile).getFuelRuntime())) {
                        ItemStack stack = ((TileEntityReactorCell)tile).getFuelRodStack();
                        ((TileEntityReactorCell)tile).setFuelRod(this.getFuelRodStack());
                        this.setFuelRod(stack);
                    }
                } else {
                    ((TileEntityReactorCell)tile).setFuelRod(this.getFuelRodStack());
                    this.setFuelRod(null);
                }
            }
        } else if (this._running) {
            AtomicScience.sideProxy.spawnParticle("reactor:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void doOperationTick() {
    }

    protected int getActualHeat(int heat) {
        return heat;
    }

    protected void consumeFuel(int ticks) {
        IFuelRodItem fuelRodItem = this.getFuelRod();
        if (fuelRodItem != null) {
            this.func_70299_a(0, fuelRodItem.onReactorTick(this, this.getFuelRodStack(), ticks, this.getFuelRuntime()));
        }
    }

    protected boolean canOperate() {
        return this.hasFuel() && this.getFuelRuntime() > 0;
    }

    @Override
    protected void onSlotStackChanged(ItemStack prev, ItemStack stack, int slot) {
        super.onSlotStackChanged(prev, stack, slot);
        if (this.isServer()) {
            this.syncClientNextTick();
            MapHandler.RADIATION_MAP.addSource(this);
            MapHandler.THERMAL_MAP.addSource(this);
        }
    }

    public boolean hasFuel() {
        return this.getFuelRod() != null;
    }

    public int getFuelRuntime() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getFuelRodRuntime(this.getFuelRodStack(), this);
        }
        return 0;
    }

    public int getMaxFuelRuntime() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getMaxFuelRodRuntime(this.getFuelRodStack(), this);
        }
        return 0;
    }

    @Override
    public IFuelRodItem getFuelRod() {
        ItemStack stack = this.getFuelRodStack();
        return stack != null && stack.func_77973_b() instanceof IFuelRodItem ? (IFuelRodItem)stack.func_77973_b() : null;
    }

    public void setFuelRod(ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    @Override
    public ItemStack getFuelRodStack() {
        return this.func_70301_a(0);
    }

    @Override
    public int getRadioactiveMaterial() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getRadioactiveMaterial(this.getFuelRodStack(), this);
        }
        return 0;
    }

    @Override
    public boolean isRadioactive() {
        return !this.func_145837_r() && this.getRadioactiveMaterial() > 0;
    }

    @Override
    public boolean canGeneratingHeat() {
        return !this.func_145837_r() && this.getHeatGenerated() > 0;
    }

    @Override
    public int getHeatGenerated() {
        IFuelRodItem fuelRodItem = this.getFuelRod();
        if (fuelRodItem != null) {
            return this.getActualHeat(fuelRodItem.getHeatOutput(this.getFuelRodStack(), this));
        }
        return 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && stack.func_77973_b() instanceof IFuelRodItem;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return ACCESSIBLE_SIDES;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return 0 == slot;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (0 == slot) {
            if (stack.func_77973_b() instanceof IFuelRodItem) {
                return ((IFuelRodItem)stack.func_77973_b()).getFuelRodRuntime(stack, this) <= 0;
            }
            return true;
        }
        return false;
    }

    public boolean shouldRenderFuel() {
        return this._renderFuel;
    }

    public float getFuelRenderLevel() {
        if (this.isServer()) {
            return (float)this.getFuelRuntime() / (float)this.getMaxFuelRuntime();
        }
        return this._renderFuelLevel;
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        super.writeDescPacket(dataList, player);
        dataList.add(this._running || this.canOperate());
        dataList.add(this.hasFuel());
        dataList.add(Float.valueOf(this.getFuelRenderLevel()));
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        super.readDescPacket(buf, player);
        this._running = buf.readBoolean();
        this._renderFuel = buf.readBoolean();
        this._renderFuelLevel = buf.readFloat();
    }

    public void updateStructureType() {
        Block blockAbove = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        Block blockBelow = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.structureType = blockAbove == ASBlocks.blockReactorCell && blockBelow == ASBlocks.blockReactorCell ? StructureType.MIDDLE : (blockBelow == ASBlocks.blockReactorCell ? StructureType.TOP : (blockAbove == ASBlocks.blockReactorCell ? StructureType.BOTTOM : StructureType.NORMAL));
    }

    public boolean isTop() {
        return this.structureType == StructureType.TOP;
    }

    public boolean isMiddle() {
        return this.structureType == StructureType.MIDDLE;
    }

    public boolean isBottom() {
        return this.structureType == StructureType.BOTTOM;
    }

    public static enum StructureType {
        NORMAL,
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

