/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.steam.funnel;

import com.builtbroken.atomic.content.ASFluids;
import com.builtbroken.atomic.content.machines.steam.SteamTank;
import com.builtbroken.atomic.content.machines.steam.TileEntitySteamInput;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySteamFunnel
extends TileEntitySteamInput
implements IFluidHandler {
    private FluidTank tank = new SteamTank(this, 10000);

    @Override
    public void firstTick() {
        super.firstTick();
    }

    @Override
    protected void update(int ticks) {
        super.update(ticks);
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != ASFluids.STEAM.fluid) {
            this.tank.drain(this.tank.getCapacity(), true);
        }
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            int amountToGive = this.tank.getFluidAmount();
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                IFluidHandler fluidHandler;
                int x = this.field_145851_c + direction.offsetX;
                int y = this.field_145848_d + direction.offsetY;
                int z = this.field_145849_e + direction.offsetZ;
                TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                if (!(tile instanceof IFluidHandler) || !(fluidHandler = (IFluidHandler)tile).canFill(direction.getOpposite(), this.tank.getFluid().getFluid())) continue;
                int give = amountToGive / 6;
                give = fluidHandler.fill(direction.getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), give), true);
                amountToGive -= give;
            }
            this.tank.drain(this.tank.getFluidAmount() - amountToGive, true);
        }
        if (this.getSteamGeneration() > 0) {
            this.tank.fill(new FluidStack(ASFluids.STEAM.fluid, this.getSteamGeneration()), true);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.writeToNBT(nbt.func_74775_l("fluid_tank"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("fluid_tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && this.tank.getFluid() != null && resource.getFluid() == this.tank.getFluid().getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == ASFluids.STEAM.fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }
}

