/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.recipes;

import com.builtbroken.atomic.config.ConfigRecipe;
import com.builtbroken.atomic.content.ASBlocks;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.proxy.ContentProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ASRecipes
extends ContentProxy {
    public static boolean disableRecipes = false;
    public static boolean allowAltItems = true;

    public ASRecipes() {
        super("recipes");
    }

    @Override
    public void init() {
        if (!ConfigRecipe.DISABLE_BASE_RECIPES && !disableRecipes) {
            this.itemRecipes();
            this.machineRecipes();
            this.reactorRecipes();
            this.armorRecipes();
            this.toolRecipes();
        }
    }

    private void itemRecipes() {
        ASRecipes.addRecipe(new ItemStack(ASItems.itemEmptyCell), " T ", "TGT", " T ", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('T'), ASRecipes.getOreItem("ingotTin", Items.field_151042_j));
        ASRecipes.addRecipe(new ItemStack(ASItems.itemFissileFuelCell), "PPP", "PTP", "PPP", Character.valueOf('P'), ASItems.itemUranium235, Character.valueOf('T'), ASItems.itemEmptyCell);
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemFluidCell), "TS", "ST", Character.valueOf('S'), Items.field_151123_aH, Character.valueOf('T'), ASItems.itemEmptyCell);
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemPoweredCell), "TC", "CB", Character.valueOf('C'), ASRecipes.getOreItem("circuitAdvanced", Blocks.field_150340_R), Character.valueOf('B'), ASRecipes.getOreItem("battery", Blocks.field_150451_bX), Character.valueOf('T'), ASItems.itemEmptyCell);
    }

    private void machineRecipes() {
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockChemCentrifuge), "ICI", "TMT", "TPT", Character.valueOf('I'), ASRecipes.getOreItem("ingotSteel", Items.field_151042_j), Character.valueOf('T'), ASItems.itemEmptyCell, Character.valueOf('M'), ASRecipes.getOreItem("motor", Items.field_151107_aW), Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Items.field_151043_k), Character.valueOf('C'), ASRecipes.getOreItem("circuitAdvanced", Items.field_151137_ax));
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockChemBoiler), "PCP", "TFT", "PMP", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('T'), ASItems.itemEmptyCell, Character.valueOf('M'), ASRecipes.getOreItem("motor", Items.field_151107_aW), Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Items.field_151043_k), Character.valueOf('C'), ASRecipes.getOreItem("circuitAdvanced", Items.field_151137_ax));
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockChemExtractor), "IPI", "MCM", "IPI", Character.valueOf('I'), ASRecipes.getOreItem("ingotSteel", Items.field_151042_j), Character.valueOf('M'), ASRecipes.getOreItem("motor", Items.field_151107_aW), Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Items.field_151043_k), Character.valueOf('C'), ASRecipes.getOreItem("circuitElite", Blocks.field_150340_R));
    }

    private void reactorRecipes() {
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockReactorCell), new Object[]{"PCP", "MTM", "PCP", Character.valueOf('M'), ASRecipes.getOreItem("motor", Items.field_151107_aW), Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Blocks.field_150339_S), Character.valueOf('C'), ASRecipes.getOreItem("circuitAdvanced", Blocks.field_150367_z), Character.valueOf('C'), ASItems.itemPoweredCell});
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockSteamTurbine), "IPI", "PMP", "IPI", Character.valueOf('M'), ASRecipes.getOreItem("motor", Items.field_151107_aW), Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Blocks.field_150339_S), Character.valueOf('I'), ASRecipes.getOreItem("rodIron", Blocks.field_150411_aY));
        ASRecipes.addRecipe(new ItemStack(ASBlocks.blockSteamFunnel), "IPI", "PHP", "IPI", Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('P'), ASRecipes.getOreItem("plateIron", Blocks.field_150339_S), Character.valueOf('I'), ASRecipes.getOreItem("rodIron", Blocks.field_150411_aY));
    }

    private void armorRecipes() {
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemArmorHazmatHelm), "CCC", "ILI", "GHG", Character.valueOf('I'), ASRecipes.getOreItem("ingotLead", Items.field_151042_j), Character.valueOf('C'), Blocks.field_150325_L, Character.valueOf('L'), Items.field_151024_Q, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('H'), ASRecipes.getOreItem("circuitBasic", Blocks.field_150340_R));
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemArmorHazmatChest), "CCC", "ILI", "THT", Character.valueOf('I'), ASRecipes.getOreItem("ingotLead", Items.field_151042_j), Character.valueOf('C'), Blocks.field_150325_L, Character.valueOf('L'), Items.field_151027_R, Character.valueOf('T'), ASItems.itemEmptyCell, Character.valueOf('H'), ASRecipes.getOreItem("circuitBasic", Blocks.field_150340_R));
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemArmorHazmatLegs), "CCC", "ILI", "CHC", Character.valueOf('I'), ASRecipes.getOreItem("ingotLead", Items.field_151042_j), Character.valueOf('C'), Blocks.field_150325_L, Character.valueOf('L'), Items.field_151026_S, Character.valueOf('H'), ASRecipes.getOreItem("circuitBasic", Blocks.field_150340_R));
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemArmorHazmatBoots), "CCC", "ILI", "CHC", Character.valueOf('I'), ASRecipes.getOreItem("ingotLead", Items.field_151042_j), Character.valueOf('C'), Blocks.field_150325_L, Character.valueOf('L'), Items.field_151021_T, Character.valueOf('H'), ASRecipes.getOreItem("circuitBasic", Blocks.field_150340_R));
    }

    private void toolRecipes() {
        ASRecipes.addRecipe(new ItemStack(ASItems.itemHeatProbe), "ICI", "ICI", "WBW", Character.valueOf('I'), ASRecipes.getOreItem("ingotSteel", Items.field_151042_j), Character.valueOf('W'), ASRecipes.getOreItem("wireCopper", Items.field_151043_k), Character.valueOf('B'), Items.field_151074_bl, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('C'), ASRecipes.getOreItem("circuitBasic", Blocks.field_150340_R));
        ASRecipes.addRecipe(new ItemStack((Item)ASItems.itemWrench), "ICI", "GIG", "GIG", Character.valueOf('I'), ASRecipes.getOreItem("ingotSteel", Items.field_151042_j), Character.valueOf('G'), Blocks.field_150325_L, Character.valueOf('C'), ASRecipes.getOreItem("circuitBasic", Items.field_151137_ax));
    }

    public static void addRecipe(ItemStack output, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, params));
    }

    public static Item getItem(String id) {
        return (Item)Item.field_150901_e.func_82594_a(id);
    }

    public static ItemStack getItem(String id, int meta) {
        Item item = ASRecipes.getItem(id);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block block = ASRecipes.getBlock(id);
        if (block != null && block != Blocks.field_150350_a) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    public static Block getBlock(String id) {
        return (Block)Block.field_149771_c.func_82594_a(id);
    }

    public static Object getOreItem(String ore_name, ItemStack alt) {
        if (OreDictionary.doesOreNameExist((String)ore_name)) {
            for (ItemStack itemStack : OreDictionary.getOres((String)ore_name)) {
                if (itemStack == null) continue;
                return ore_name;
            }
        }
        return allowAltItems && alt != null ? alt : ore_name;
    }

    public static Object getOreItem(String ore_name, Item alt) {
        if (OreDictionary.doesOreNameExist((String)ore_name)) {
            for (ItemStack itemStack : OreDictionary.getOres((String)ore_name)) {
                if (itemStack == null) continue;
                return ore_name;
            }
        }
        return allowAltItems && alt != null ? alt : ore_name;
    }

    public static Object getOreItem(String ore_name, Block alt) {
        if (OreDictionary.doesOreNameExist((String)ore_name)) {
            for (ItemStack itemStack : OreDictionary.getOres((String)ore_name)) {
                if (itemStack == null) continue;
                return ore_name;
            }
        }
        return allowAltItems && alt != null ? alt : ore_name;
    }
}

