/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib;

import com.builtbroken.atomic.AtomicScience;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import scala.actors.threadpool.Arrays;

public class LanguageUtility {
    public static int toolTipLineLength = 120;

    public static String getLocal(String key) {
        if (key == null || key.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocal(" + key + ") - invalid key", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        String translation = StatCollector.func_74838_a((String)key);
        if (translation == null || translation.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static String getLocalName(String key) {
        String translation;
        if (key == null || key.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocalName(" + key + ")", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        if (!key.endsWith(".name")) {
            key = key + ".name";
        }
        if ((translation = StatCollector.func_74838_a((String)key)) == null || translation.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static Integer getLangSetting(String key, int backup) {
        block3: {
            String result = LanguageUtility.getLocal(key);
            if (result != null && !result.isEmpty()) {
                try {
                    return Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    if (!AtomicScience.runningAsDev) break block3;
                    AtomicScience.logger.error("LanguageUtility.getLangSetting(" + key + ")", (Throwable)e);
                }
            }
        }
        return backup;
    }

    public static IChatComponent getLocalChat(String key) {
        String translation = LanguageUtility.getLocalName(key);
        if (translation == null || translation.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocalChat(" + key + ")", (Throwable)new RuntimeException());
            }
            return new ChatComponentText("error.translation.empty");
        }
        return new ChatComponentText(translation);
    }

    public static void addChatToPlayer(EntityPlayer player, String key) {
        if (player != null) {
            player.func_146105_b(LanguageUtility.getLocalChat(key));
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("LanguageUtility.addChatToPlayer(Null Player, " + key + ")", (Throwable)new RuntimeException());
        }
    }

    public static List<String> splitStringPerWord(String string) {
        return Arrays.asList((Object[])LanguageUtility.toWordArray(string));
    }

    public static String[] toWordArray(String string) {
        return string.trim().split("\\W+");
    }

    public static List<String> splitByLine(String string, int charsPerLine) {
        if (string.length() < charsPerLine) {
            return Lists.newArrayList((Object[])new String[]{string});
        }
        String[] words = LanguageUtility.toWordArray(string);
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        for (String word : words) {
            if (word.length() + line.length() <= charsPerLine) {
                line = line + word;
                continue;
            }
            lines.add(line);
            line = word;
        }
        if (lines.isEmpty()) {
            lines.add(line);
        }
        return lines;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String decapitalizeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }
}

