/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.network.netty;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.lib.network.IPacket;
import com.builtbroken.atomic.lib.network.packet.PacketPlayerItem;
import com.builtbroken.atomic.lib.network.packet.PacketTile;
import com.builtbroken.atomic.lib.network.packet.client.PacketSpawnParticle;
import com.builtbroken.atomic.lib.network.packet.sync.PacketPlayerRadiation;
import com.builtbroken.atomic.lib.network.packet.trigger.PacketMouse;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class PacketEncoderDecoderHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public boolean silenceStackTrace = false;
    private int nextID = 0;

    public PacketEncoderDecoderHandler() {
        this.addPacket(PacketTile.class);
        this.addPacket(PacketPlayerItem.class);
        this.addPacket(PacketPlayerRadiation.class);
        this.addPacket(PacketSpawnParticle.class);
        this.addPacket(PacketMouse.class);
    }

    public void addPacket(Class<? extends IPacket> clazz) {
        this.addDiscriminator(this.nextID++, clazz);
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket packet, ByteBuf target) throws Exception {
        try {
            packet.encodeInto(ctx, target);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                AtomicScience.logger.error("Failed to encode packet " + packet, (Throwable)e);
            }
            AtomicScience.logger.error("Failed to encode packet " + packet + " E: " + e.getMessage());
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket packet) {
        try {
            packet.decodeInto(ctx, source);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                AtomicScience.logger.error("Failed to decode packet " + packet, (Throwable)e);
            }
            AtomicScience.logger.error("Failed to decode packet " + packet + " E: " + e.getMessage());
        }
    }
}

