/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.network.packet;

import com.builtbroken.atomic.lib.network.IPacket;
import com.builtbroken.atomic.lib.transform.vector.Pos;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;

public class PacketBase
implements IPacket {
    protected List<Object> dataToWrite = new ArrayList<Object>();
    protected ByteBuf dataToRead;

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        for (Object object : this.dataToWrite) {
            this.writeData(object, buffer);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dataToRead = buffer.slice().copy();
    }

    protected void writeData(Object object, ByteBuf buffer) {
        if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.writeData(Array.get(object, i), buffer);
            }
        } else if (object instanceof Collection) {
            for (Object o : (Collection)object) {
                this.writeData(o, buffer);
            }
        } else if (object instanceof Byte) {
            buffer.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Integer) {
            buffer.writeInt(((Integer)object).intValue());
        } else if (object instanceof Short) {
            buffer.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Long) {
            buffer.writeLong(((Long)object).longValue());
        } else if (object instanceof Float) {
            buffer.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            buffer.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof Boolean) {
            buffer.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof String) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)object));
        } else if (object instanceof NBTTagCompound) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)object));
        } else if (object instanceof ItemStack) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack)object));
        } else if (object instanceof FluidTank) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((FluidTank)object).writeToNBT(new NBTTagCompound()));
        } else if (object instanceof Pos) {
            ((Pos)object).writeByteBuf(buffer);
        } else if (object instanceof IByteBufWriter) {
            ((IByteBufWriter)object).writeBytes(buffer);
        } else if (object instanceof Enum) {
            buffer.writeInt(((Enum)object).ordinal());
        } else {
            throw new IllegalArgumentException("PacketBase: Unsupported write data type " + object);
        }
    }

    public ByteBuf dataToRead() {
        return this.dataToRead;
    }

    @Override
    public <P extends IPacket> P addData(Object ... objects) {
        for (Object object : objects) {
            this.dataToWrite.add(object);
        }
        return (P)this;
    }
}

