/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.network.packet;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.lib.network.IPacketIDReceiver;
import com.builtbroken.atomic.lib.network.ex.PacketTileReadException;
import com.builtbroken.atomic.lib.network.packet.PacketBase;
import com.builtbroken.atomic.lib.transform.vector.Location;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTile
extends PacketBase {
    public int x;
    public int y;
    public int z;
    public int id;
    public String name;

    public PacketTile() {
    }

    public PacketTile(String name, int id, int x, int y, int z) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketTile(String name, int id, TileEntity tile) {
        this(name, id, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(AtomicScience.runningAsDev);
        if (AtomicScience.runningAsDev) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        }
        buffer.writeInt(this.id);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.id = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        super.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handleClientSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handleServerSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    public void handle(EntityPlayer player) {
        if (player.func_130014_f_() == null) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("PacketTile#handle(" + player + ") - world is null for player while handling packet. ", (Throwable)new RuntimeException());
            }
            return;
        }
        if (player.func_130014_f_().func_72899_e(this.x, this.y, this.z)) {
            this.handle(player, player.func_130014_f_().func_147438_o(this.x, this.y, this.z));
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handle(" + player + ") - block is not loaded for player while handling packet. ");
        }
    }

    public void handle(EntityPlayer player, TileEntity tile) {
        Location location = new Location(player.field_70170_p, this.x, this.y, this.z);
        if (tile == null) {
            AtomicScience.logger.error((Object)new PacketTileReadException(location, "Null tile"));
        } else if (tile.func_145837_r()) {
            AtomicScience.logger.error((Object)new PacketTileReadException(location, "Invalidated tile"));
        } else if (tile instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)tile).shouldReadPacket(player, location, this)) {
                try {
                    IPacketIDReceiver receiver = (IPacketIDReceiver)tile;
                    receiver.read(this.dataToRead, this.id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Null pointer while reading data", e));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
            } else {
                AtomicScience.logger.error("Error: " + tile + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            AtomicScience.logger.error((Object)new PacketTileReadException(location, "Unsupported action for " + tile));
        }
    }
}

