/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.oregen;

import com.builtbroken.atomic.lib.oregen.OreGenerator;
import com.builtbroken.atomic.lib.oregen.OreGeneratorSettings;
import com.builtbroken.atomic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraftforge.common.util.ForgeDirection;

public class OreGenReplace
extends OreGenerator {
    public final OreGeneratorSettings settings;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;

    public OreGenReplace(Block block, int meta, OreGeneratorSettings settings, String harvestTool, int harvestLevel) {
        super(block, meta, harvestTool, harvestLevel);
        this.settings = settings;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        int placed;
        for (int blocksPlaced = 0; blocksPlaced < this.settings.amountPerChunk; blocksPlaced += placed) {
            int x = varX + random.nextInt(16);
            int z = varZ + random.nextInt(16);
            int y = random.nextInt(Math.max(this.settings.maxGenerateLevel - this.settings.minGenerateLevel, 0)) + this.settings.minGenerateLevel;
            placed = this.generateBranch(world, random, varX, varZ, x, y, z);
            if (placed > 0) continue;
            placed = this.settings.amountPerBranch;
        }
    }

    public int generateBranch(World world, Random rand, int chunkCornerX, int chunkCornerZ, int varX, int varY, int varZ) {
        int blocksPlaced = 0;
        ArrayList<Pos> pathed = new ArrayList<Pos>();
        LinkedList<Pos> toPath = new LinkedList<Pos>();
        toPath.add(new Pos(varX, varY, varZ));
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            directions.add(dir);
        }
        while (!toPath.isEmpty() && blocksPlaced < this.settings.amountPerBranch) {
            Pos next = (Pos)toPath.poll();
            pathed.add(next);
            Block block = next.getBlock((IBlockAccess)world);
            if ((this.settings.replaceBlock == null || block == this.settings.replaceBlock) && next.setBlock(world, this.oreBlock, this.oreMeta, 2)) {
                ++blocksPlaced;
            }
            Collections.shuffle(directions);
            for (ForgeDirection direction : directions) {
                Pos pos = (Pos)next.add(direction);
                if (pathed.contains(pos) || !world.field_73012_v.nextBoolean()) continue;
                if (pos.isInsideMap() && world.func_72899_e(pos.xi(), pos.yi(), pos.zi())) {
                    boolean insideY;
                    boolean insideX = pos.xi() >= chunkCornerX && pos.xi() < chunkCornerX + 16;
                    boolean insideZ = pos.zi() >= chunkCornerZ && pos.zi() < chunkCornerZ + 16;
                    boolean bl = insideY = pos.yi() >= this.settings.minGenerateLevel && pos.yi() <= this.settings.maxGenerateLevel;
                    if (insideX && insideZ && insideY) {
                        block = pos.getBlock((IBlockAccess)world);
                        if (this.settings.replaceBlock == null || block == this.settings.replaceBlock) {
                            toPath.add(pos);
                        }
                    }
                }
                if (toPath.contains(pos)) continue;
                pathed.add(pos);
            }
        }
        return blocksPlaced;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkProvider chunkGenerator) {
        if (this.ignoreSurface && chunkGenerator instanceof ChunkProviderGenerate) {
            return false;
        }
        if (this.ignoreNether && chunkGenerator instanceof ChunkProviderHell) {
            return false;
        }
        return !this.ignoreEnd || !(chunkGenerator instanceof ChunkProviderEnd);
    }
}

