/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.placement;

import com.builtbroken.atomic.AtomicScience;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockPlacement {
    public int dim;
    public int x;
    public int y;
    public int z;
    public Block block;
    public int meta;
    public int placementDelay = 0;

    public BlockPlacement(World world, int x, int y, int z, Block block, int meta) {
        this.dim = world.field_73011_w.field_76574_g;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = block;
        this.meta = meta;
    }

    public BlockPlacement delay(int ticks) {
        this.placementDelay = ticks;
        return this;
    }

    public boolean doPlacement() {
        if (this.placementDelay-- > 0) {
            return false;
        }
        try {
            if (this.canDoAction()) {
                World world = this.world();
                if (world != null) {
                    if (world.func_147465_d(this.x, this.y, this.z, this.block, this.meta, 3)) {
                        world.func_147471_g(this.x, this.y, this.z);
                        this.onPlacedBlock();
                    } else {
                        AtomicScience.logger.error("PlacementQueue: Failed to place block in world. " + this);
                    }
                } else {
                    AtomicScience.logger.error("PlacementQueue: Failed to get world for placement. " + this);
                }
            }
        }
        catch (Exception e) {
            AtomicScience.logger.error("PlacementQueue: Unexpected error placing block. " + this, (Throwable)e);
        }
        return true;
    }

    protected void onPlacedBlock() {
    }

    protected boolean canDoAction() {
        return true;
    }

    public World world() {
        return DimensionManager.getWorld((int)this.dim);
    }

    public String toString() {
        return "BlockPlacement[" + this.dim + " | " + this.x + ", " + this.y + ", " + this.z + " | " + this.block + " @ " + this.meta + "]";
    }
}

