/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.placement;

import com.builtbroken.atomic.lib.placement.BlockPlacement;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class PlacementQueue {
    private static final ConcurrentLinkedQueue<BlockPlacement> queue = new ConcurrentLinkedQueue();

    public static void queue(World world, int x, int y, int z, Block block, int meta) {
        PlacementQueue.queue(new BlockPlacement(world, x, y, z, block, meta));
    }

    public static void queue(BlockPlacement placement) {
        if (placement != null && placement.block != null) {
            queue.add(placement);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long time = System.currentTimeMillis();
            LinkedList<BlockPlacement> delayList = new LinkedList<BlockPlacement>();
            while (!queue.isEmpty() && System.currentTimeMillis() - time < 10L) {
                BlockPlacement placement = queue.poll();
                if (placement == null || placement.doPlacement()) continue;
                delayList.add(placement);
            }
            queue.addAll(delayList);
        }
    }
}

