/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.power;

import com.builtbroken.atomic.lib.power.PowerHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerSystem {
    private static final List<PowerHandler> powerHandlers = new ArrayList<PowerHandler>();

    public static int addPower(ForgeDirection sideAccessed, TileEntity tileEntity, int power, boolean doAction) {
        PowerHandler handler = PowerSystem.getHandler(sideAccessed, tileEntity);
        if (handler != null) {
            return handler.addPower(sideAccessed, tileEntity, power, doAction);
        }
        return 0;
    }

    public static boolean canSupport(ForgeDirection sideToAccess, TileEntity tileEntity) {
        return PowerSystem.getHandler(sideToAccess, tileEntity) != null;
    }

    public static PowerHandler getHandler(ForgeDirection sideToAccess, TileEntity tileEntity) {
        for (PowerHandler handler : powerHandlers) {
            if (!handler.canHandle(sideToAccess, tileEntity)) continue;
            return handler;
        }
        return null;
    }

    public static PowerHandler getHandler(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            for (PowerHandler handler : powerHandlers) {
                if (!handler.canHandle(stack)) continue;
                return handler;
            }
        }
        return null;
    }

    public static int outputPower(World world, int x, int y, int z, ForgeDirection direction, int powerToOutput, boolean doAction) {
        TileEntity tile;
        if (powerToOutput > 0 && (tile = world.func_147438_o(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ)) != null) {
            return PowerSystem.addPower(direction.getOpposite(), tile, powerToOutput, doAction);
        }
        return 0;
    }

    public static void register(PowerHandler powerHandler) {
        if (powerHandler != null) {
            powerHandlers.add(powerHandler);
        }
    }

    public static int getEnergyStored(ItemStack itemStack) {
        PowerHandler handler = PowerSystem.getHandler(itemStack);
        if (handler != null) {
            return handler.getPowerStored(itemStack);
        }
        return 0;
    }

    public static int removePower(ItemStack itemStack, int amount, boolean doAction) {
        PowerHandler handler = PowerSystem.getHandler(itemStack);
        if (handler != null) {
            return handler.removePower(itemStack, amount, false);
        }
        return 0;
    }
}

