/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.thermal;

import com.builtbroken.atomic.api.thermal.IHeatSource;
import com.builtbroken.atomic.config.ConfigPower;
import com.builtbroken.atomic.lib.MassHandler;
import com.builtbroken.atomic.lib.placement.PlacementQueue;
import com.builtbroken.atomic.lib.thermal.ThermalData;
import com.builtbroken.atomic.lib.thermal.ThermalPlacement;
import com.builtbroken.atomic.map.MapHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ThermalHandler {
    private static final HashMap<Block, ThermalData> blockThermalDataMap = new HashMap();

    public static void init() {
        ThermalHandler.setValue(Blocks.field_150355_j, 0.58f, 4.187f, 2257.0f, 373.15f);
        ThermalHandler.setValue(Blocks.field_150432_aD, 2.18f, 2.108f, 334.0f, 273.15f, Blocks.field_150355_j, 0);
        ThermalHandler.setValue(Blocks.field_150350_a, 0.024f, 0.718f, -1.0f, -1.0f);
        ThermalHandler.setValue(Blocks.field_150339_S, 55.0f, 0.444f, -1.0f, 1811.15f);
        ThermalHandler.setValue(Blocks.field_150340_R, 315.0f, 0.129f, -1.0f, 1337.15f);
    }

    public static void setValue(Block block, float rate, float specificHeat, float changeHeat, float changeTemp) {
        ThermalHandler.setValue(block, rate, specificHeat, changeHeat, changeTemp, null, 0);
    }

    public static void setValue(Block block, float rate, float specificHeat, float changeHeat, float changeTemp, Block changeBlock, int changeMeta) {
        blockThermalDataMap.put(block, new ThermalData(rate, specificHeat, changeHeat, changeTemp, changeBlock, changeMeta));
    }

    public static ThermalData getThermalData(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (blockThermalDataMap.containsKey(block)) {
            return blockThermalDataMap.get(block);
        }
        return null;
    }

    public static boolean canChangeStates(World world, int x, int y, int z) {
        ThermalData data = ThermalHandler.getThermalData(world, x, y, z);
        if (data != null) {
            return data.changeBlock != null;
        }
        return false;
    }

    public static long energyCostToChangeStates(World world, int x, int y, int z) {
        ThermalData data = ThermalHandler.getThermalData(world, x, y, z);
        if (data != null) {
            float mass = MassHandler.getMass(world, x, y, z);
            return (long)((double)data.energyToChangeStates(mass) + data.energyToGetToStateChange(mass));
        }
        return 0L;
    }

    public static float getSpecificHeat(World world, int x, int y, int z) {
        ThermalData data = ThermalHandler.getThermalData(world, x, y, z);
        if (data != null) {
            return data.specificHeat;
        }
        return 0.2f;
    }

    public static double getHeatTransferRate(World world, int x, int y, int z) {
        ThermalData data = ThermalHandler.getThermalData(world, x, y, z);
        if (data != null) {
            return data.heatMovementRate;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IHeatSource) {
            return 1000.0;
        }
        return 0.1;
    }

    public static void changeStates(World world, int x, int y, int z) {
        ThermalData data = ThermalHandler.getThermalData(world, x, y, z);
        if (data != null && data.changeBlock != null) {
            float mass = MassHandler.getMass(world, x, y, z);
            double stateChangeEnergy = data.energyToChangeStates(mass);
            double energyToGetToChange = data.energyToGetToStateChange(mass);
            PlacementQueue.queue(new ThermalPlacement(world, x, y, z, data, (long)(stateChangeEnergy + energyToGetToChange)).delay(1 + (int)(Math.random() * 10.0)));
        }
    }

    public static int getVaporRate(World world, int x, int y, int z) {
        return ThermalHandler.getVaporRate(world, x, y, z, MapHandler.THERMAL_MAP.getActualJoules(world, x, y, z));
    }

    public static int getVaporRate(World world, int x, int y, int z, long heat) {
        Block block = world.func_147439_a(x, y, z);
        double temperature = MapHandler.THERMAL_MAP.getTemperature(world, x, y, z, heat);
        if (block == Blocks.field_150355_j) {
            if (temperature > 373.0) {
                return (int)Math.min((double)ConfigPower.WATER_VAPOR_MAX_RATE, Math.ceil((double)ConfigPower.WATER_VAPOR_RATE * (temperature / 373.0)));
            }
        } else if (block == Blocks.field_150358_i && temperature > 373.0) {
            return (int)Math.min((double)ConfigPower.WATER_VAPOR_MAX_RATE, Math.ceil((double)ConfigPower.WATER_FLOWING_VAPOR_RATE * (temperature / 373.0)));
        }
        return 0;
    }
}

