/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.region;

import com.builtbroken.atomic.lib.transform.region.Rectangle;
import com.builtbroken.atomic.lib.transform.region.Shape3D;
import com.builtbroken.atomic.lib.transform.vector.Point;
import com.builtbroken.atomic.lib.transform.vector.Pos;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import com.builtbroken.jlib.data.vector.IPos3D;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class Cube
extends Shape3D
implements Cloneable,
IByteBufWriter {
    public static final Cube EMPTY = new Cube().disableEdits();
    public static final Cube FULL = new Cube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).disableEdits();
    private IPos3D pointOne;
    private IPos3D pointTwo;
    private Pos lowerPoint;
    private Pos higherPoint;
    private boolean canEdit = true;

    public Cube() {
        this(new Pos(0.0, -1.0, 0.0), new Pos(0.0, -1.0, 0.0));
    }

    public Cube(IPos3D min, IPos3D max) {
        super((Pos)null);
        this.set(min, max);
    }

    public Cube(Cube cube) {
        this(cube.pointOne(), cube.pointTwo());
    }

    public Cube(double x, double y, double z, double i, double j, double k) {
        this(new Pos(x, y, z), new Pos(i, j, k));
    }

    public Cube(AxisAlignedBB bb) {
        this(new Pos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Pos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f));
    }

    public Cube(NBTTagCompound nbt) {
        super(nbt);
        if (nbt.func_74764_b("pointOne")) {
            this.pointOne = new Pos(nbt.func_74775_l("pointOne"));
        }
        if (nbt.func_74764_b("pointTwo")) {
            this.pointTwo = new Pos(nbt.func_74775_l("pointTwo"));
        }
        this.recalc();
    }

    public Cube(ByteBuf buf) {
        this(new Pos(buf), new Pos(buf));
    }

    public Cube enableEdits() {
        this.canEdit = true;
        return this;
    }

    public Cube disableEdits() {
        this.canEdit = false;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf buf) {
        buf.writeDouble(this.pointOne != null ? this.pointOne.x() : 0.0);
        buf.writeDouble(this.pointOne != null ? this.pointOne.y() : -1.0);
        buf.writeDouble(this.pointOne != null ? this.pointOne.z() : 0.0);
        buf.writeDouble(this.pointTwo != null ? this.pointTwo.x() : 0.0);
        buf.writeDouble(this.pointTwo != null ? this.pointTwo.y() : -1.0);
        buf.writeDouble(this.pointTwo != null ? this.pointTwo.z() : 0.0);
        return buf;
    }

    public AxisAlignedBB toAABB() {
        return this.isValid() ? AxisAlignedBB.func_72330_a((double)this.min().x(), (double)this.min().y(), (double)this.min().z(), (double)this.max().x(), (double)this.max().y(), (double)this.max().z()) : AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public AxisAlignedBB getAABB() {
        return AxisAlignedBB.func_72330_a((double)this.min().x(), (double)this.min().y(), (double)this.min().z(), (double)this.max().x(), (double)this.max().y(), (double)this.max().z());
    }

    public Rectangle toRectangle() {
        return this.isValid() ? new Rectangle(new Point(this.min()), new Point(this.max())) : null;
    }

    public NBTTagCompound toNBT() {
        return this.save(new NBTTagCompound());
    }

    public NBTTagCompound save(NBTTagCompound tag) {
        if (this.pointOne != null) {
            tag.func_74782_a("pointOne", (NBTBase)new Pos(this.pointOne).writeNBT(new NBTTagCompound()));
        }
        if (this.pointTwo != null) {
            tag.func_74782_a("pointTwo", (NBTBase)new Pos(this.pointTwo).writeNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public Cube add(IPos3D vec) {
        return this.add(vec.x(), vec.y(), vec.z());
    }

    public Cube add(double x, double y, double z) {
        if (this.isValid() && this.canEdit) {
            this.pointOne = new Pos(this.pointOne.x() + x, this.pointOne.y() + y, this.pointOne.z() + z);
            this.pointTwo = new Pos(this.pointTwo.x() + x, this.pointTwo.y() + y, this.pointTwo.z() + z);
            this.recalc();
        }
        return this;
    }

    public Cube subtract(IPos3D vec) {
        return this.subtract(vec.x(), vec.y(), vec.z());
    }

    public Cube subtract(double x, double y, double z) {
        if (this.isValid() && this.canEdit) {
            this.pointOne = new Pos(this.pointOne.x() - x, this.pointOne.y() - y, this.pointOne.z() - z);
            this.pointTwo = new Pos(this.pointTwo.x() - x, this.pointTwo.y() - y, this.pointTwo.z() - z);
            this.recalc();
        }
        return this;
    }

    public boolean intersects(Vec3 v) {
        return this.intersects(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public boolean intersects(IPos3D v) {
        return this.intersects(v.x(), v.y(), v.z());
    }

    public boolean intersects(double x, double y, double z) {
        return this.isWithinX(x) && this.isWithinY(y) && this.isWithinZ(z);
    }

    public boolean doesOverlap(AxisAlignedBB box) {
        return this.doesOverlap(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public boolean doesOverlap(Cube box) {
        return box.isValid() && this.doesOverlap(box.min().x(), box.min().y(), box.min().z(), box.max().x(), box.max().y(), box.max().z());
    }

    public boolean doesOverlap(double x, double y, double z, double i, double j, double k) {
        return !this.isOutSideX(x, i) || !this.isOutSideY(y, j) || !this.isOutSideZ(z, k);
    }

    public boolean isOutSideX(double min, double max) {
        return this.min().x() > min || max > this.max().x();
    }

    public boolean isOutSideY(double max, double min) {
        return this.min().y() > max || min > this.max().y();
    }

    public boolean isOutSideZ(double max, double min) {
        return this.min().z() > max || min > this.max().z();
    }

    public boolean isInsideBounds(double x, double y, double z, double i, double j, double k) {
        return this.isWithin(this.min().x(), this.max().x(), x, i) && this.isWithin(this.min().y(), this.max().y(), y, j) && this.isWithin(this.min().z(), this.max().z(), z, k);
    }

    public boolean isInsideBounds(Cube other) {
        return this.isInsideBounds(other.min().x(), other.min().y(), other.min().z(), other.max().x(), other.max().y(), other.max().z());
    }

    public boolean isInsideBounds(AxisAlignedBB other) {
        return this.isInsideBounds(other.field_72340_a, other.field_72338_b, other.field_72339_c, other.field_72336_d, other.field_72337_e, other.field_72334_f);
    }

    public boolean isVecInYZ(Vec3 v) {
        return this.isWithinY(v) && this.isWithinZ(v);
    }

    public boolean isVecInYZ(IPos3D v) {
        return this.isWithinY(v) && this.isWithinZ(v);
    }

    public boolean isWithinXZ(Vec3 v) {
        return this.isWithinX(v) && this.isWithinZ(v);
    }

    public boolean isWithinXZ(IPos3D v) {
        return this.isWithinX(v) && this.isWithinZ(v);
    }

    public boolean isWithinX(double v) {
        return this.isWithinRange(this.min().x(), this.max().x(), v);
    }

    public boolean isWithinX(Vec3 v) {
        return this.isWithinX(v.field_72450_a);
    }

    public boolean isWithinX(IPos3D v) {
        return this.isWithinX(v.x());
    }

    public boolean isWithinY(double v) {
        return this.isWithinRange(this.min().y(), this.max().y(), v);
    }

    public boolean isWithinY(Vec3 v) {
        return this.isWithinY(v.field_72448_b);
    }

    public boolean isWithinY(IPos3D v) {
        return this.isWithinY(v.y());
    }

    public boolean isWithinZ(double v) {
        return this.isWithinRange(this.min().z(), this.max().z(), v);
    }

    public boolean isWithinZ(Vec3 v) {
        return this.isWithinZ(v.field_72449_c);
    }

    public boolean isWithinZ(IPos3D v) {
        return this.isWithinZ(v.z());
    }

    public boolean isWithinRange(double min, double max, double v) {
        return v >= min + 1.0E-5 && v <= max - 1.0E-5;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.isWithinX(x) && this.isWithinY(y) && this.isWithinZ(z);
    }

    public boolean isWithin(double min, double max, double a, double b) {
        return a + 1.0E-5 >= min && b - 1.0E-5 <= max;
    }

    public static IPos3D[] getCorners(Cube box) {
        IPos3D[] array = new IPos3D[8];
        if (box.isValid()) {
            double l = box.pointTwo.x() - box.pointOne.x();
            double w = box.pointTwo.z() - box.pointOne.z();
            double h = box.pointTwo.y() - box.pointOne.y();
            array[0] = new Pos(box.pointOne.x(), box.pointOne.y(), box.pointOne.z());
            array[1] = new Pos(box.pointOne.x(), box.pointOne.y() + h, box.pointOne.z());
            array[2] = new Pos(box.pointOne.x(), box.pointOne.y() + h, box.pointOne.z() + w);
            array[3] = new Pos(box.pointOne.x(), box.pointOne.y(), box.pointOne.z() + w);
            array[4] = new Pos(box.pointOne.x() + l, box.pointOne.y(), box.pointOne.z());
            array[5] = new Pos(box.pointOne.x() + l, box.pointOne.y() + h, box.pointOne.z());
            array[6] = new Pos(box.pointOne.x() + l, box.pointOne.y() + h, box.pointOne.z() + w);
            array[7] = new Pos(box.pointOne.x() + l, box.pointOne.y(), box.pointOne.z() + w);
        }
        return array;
    }

    public static IPos3D[] getCorners(AxisAlignedBB box) {
        return Cube.getCorners(new Cube(box));
    }

    public double radius() {
        double m = 0.0;
        if (this.getSizeX() > m) {
            m = this.getSizeX();
        }
        if (this.getSizeY() > m) {
            m = this.getSizeY();
        }
        if (this.getSizeZ() > m) {
            m = this.getSizeZ();
        }
        return m;
    }

    @Override
    public double getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    @Override
    public double getArea() {
        double area = 0.0;
        area += this.getSizeX() * this.getSizeZ() * 2.0;
        area += this.getSizeY() * this.getSizeZ() * 2.0;
        return area += this.getSizeX() * this.getSizeY() * 2.0;
    }

    @Override
    public double getSizeX() {
        if (this.isValid()) {
            return this.max().x() - this.min().x() + 1.0;
        }
        return 0.0;
    }

    @Override
    public double getSizeY() {
        if (this.isValid()) {
            return this.max().y() - this.min().y() + 1.0;
        }
        return 0.0;
    }

    @Override
    public double getSizeZ() {
        if (this.isValid()) {
            return this.max().z() - this.min().z() + 1.0;
        }
        return 0.0;
    }

    public IPos3D pointOne() {
        return this.pointOne;
    }

    public IPos3D pointTwo() {
        return this.pointTwo;
    }

    public Pos min() {
        return this.lowerPoint;
    }

    public Pos max() {
        return this.higherPoint;
    }

    public boolean isSquared() {
        return this.getSizeX() == this.getSizeY() && this.getSizeY() == this.getSizeZ();
    }

    public boolean isSquaredInt() {
        return (int)this.getSizeX() == (int)this.getSizeY() && (int)this.getSizeY() == (int)this.getSizeZ();
    }

    public double distance(Vec3 v) {
        if (!this.isValid()) {
            if (this.min() != null) {
                return new Pos(this.min()).distance(v);
            }
            if (this.max() != null) {
                return new Pos(this.max()).distance(v);
            }
            return Double.MIN_VALUE;
        }
        return this.center.distance(v);
    }

    @Override
    public double distance(IPos3D v) {
        if (!this.isValid()) {
            if (this.min() != null) {
                return new Pos(this.min()).distance(v);
            }
            if (this.max() != null) {
                return new Pos(this.max()).distance(v);
            }
            return Double.MIN_VALUE;
        }
        return this.center.distance(v);
    }

    public double distance(Cube box) {
        return this.distance(box.center);
    }

    public double distance(AxisAlignedBB box) {
        return this.distance(new Cube(box));
    }

    public double distance(double xx, double yy, double zz) {
        if (this.isValid()) {
            Pos center = this.center;
            double x = center.x() - xx;
            double y = center.y() - yy;
            double z = center.z() - zz;
            return Math.sqrt(x * x + y * y + z * z);
        }
        return 0.0;
    }

    public List<Entity> getEntities(World world) {
        return this.getEntities(world, Entity.class);
    }

    public List getEntities(World world, Class<? extends Entity> entityClass) {
        return world.func_72872_a(entityClass, this.toAABB());
    }

    public List<TileEntity> getTilesInArea(World world) {
        ArrayList<TileEntity> tilesInArea = new ArrayList<TileEntity>();
        for (Chunk chunk : this.getChunks(world)) {
            for (Object object : chunk.field_150816_i.values()) {
                if (!(object instanceof TileEntity) || !((TileEntity)object).func_145837_r() || ((TileEntity)object).func_145831_w() == null || !this.isWithin((TileEntity)object)) continue;
                tilesInArea.add((TileEntity)object);
            }
        }
        return tilesInArea;
    }

    public List<Chunk> getChunks(World world) {
        return this.getChunks(world, true);
    }

    public List<Chunk> getChunks(World world, boolean loaded) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int chunkX = (this.min().xi() >> 4) - 1; chunkX <= (this.max().xi() >> 4) + 1; ++chunkX) {
            for (int chunkZ = (this.min().zi() >> 4) - 1; chunkZ <= (this.max().zi() >> 4) + 1; ++chunkZ) {
                Chunk chunk;
                if (!loaded && world instanceof WorldServer && !((WorldServer)world).func_72863_F().func_73149_a(chunkX, chunkZ) || (chunk = world.func_72964_e(chunkX, chunkZ)) == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public List<ChunkCoordIntPair> getChunkCoords() {
        ArrayList<ChunkCoordIntPair> chunks = new ArrayList<ChunkCoordIntPair>();
        for (int chunkX = (this.min().xi() >> 4) - 1; chunkX <= (this.max().xi() >> 4) + 1; ++chunkX) {
            for (int chunkZ = (this.min().zi() >> 4) - 1; chunkZ <= (this.max().zi() >> 4) + 1; ++chunkZ) {
                chunks.add(new ChunkCoordIntPair(chunkX, chunkZ));
            }
        }
        return chunks;
    }

    public void setPointOne(IPos3D pos) {
        if (this.canEdit) {
            this.pointOne = pos;
            this.recalc();
        }
    }

    public void setPointTwo(IPos3D pos) {
        if (this.canEdit) {
            this.pointTwo = pos;
            this.recalc();
        }
    }

    public void set(IPos3D min, IPos3D max) {
        if (this.canEdit) {
            this.pointOne = min;
            this.pointTwo = max;
            this.recalc();
        }
    }

    public Cube set(Cube cube) {
        this.set(cube.min() != null ? new Pos(cube.min()) : null, cube.max() != null ? new Pos(cube.max()) : null);
        return this;
    }

    protected void recalc() {
        if (this.canEdit) {
            if (this.pointOne != null && this.pointTwo != null) {
                this.lowerPoint = new Pos(Math.min(this.pointOne.x(), this.pointTwo.x()), Math.min(this.pointOne.y(), this.pointTwo.y()), Math.min(this.pointOne.z(), this.pointTwo.z()));
                this.higherPoint = new Pos(Math.max(this.pointOne.x(), this.pointTwo.x()), Math.max(this.pointOne.y(), this.pointTwo.y()), Math.max(this.pointOne.z(), this.pointTwo.z()));
                this.center = new Pos(this.min().x() + this.getSizeX() / 2.0, this.min().y() + this.getSizeY() / 2.0, this.min().z() + this.getSizeZ() / 2.0);
            } else {
                this.center = null;
            }
        }
    }

    public boolean isValid() {
        return this.min() != null && this.max() != null && !this.max().equals(this.min()) && this.min().y() > -1.0 && this.max().y() > -1.0;
    }

    public Cube clone() {
        return new Cube(this.pointOne, this.pointTwo);
    }

    public String toString() {
        return "Cube[" + this.pointOne + "  " + this.pointTwo + "]";
    }

    public boolean equals(Object other) {
        return other instanceof Cube && ((Cube)other).pointOne == this.pointOne && ((Cube)other).pointTwo == this.pointTwo;
    }

    public boolean isCloseToAnyCorner(IPos3D pos, int distance) {
        if (pos != null) {
            if (this.center != null && this.center.distance(pos) <= (double)distance) {
                return true;
            }
            if (this.isWithin(pos)) {
                return true;
            }
            if (this.lowerPoint != null && this.higherPoint != null) {
                if (pos.x() <= this.lowerPoint.x() && this.lowerPoint.x() - pos.x() >= (double)distance) {
                    return false;
                }
                if (pos.y() <= this.lowerPoint.y() && this.lowerPoint.y() - pos.y() >= (double)distance) {
                    return false;
                }
                if (pos.z() <= this.lowerPoint.z() && this.lowerPoint.z() - pos.z() >= (double)distance) {
                    return true;
                }
                if (pos.x() >= this.higherPoint.x() && pos.x() - this.higherPoint.x() >= (double)distance) {
                    return false;
                }
                if (pos.y() >= this.higherPoint.y() && pos.y() - this.higherPoint.y() >= (double)distance) {
                    return false;
                }
                return !(pos.z() >= this.higherPoint.z()) || !(pos.z() - this.higherPoint.z() >= (double)distance);
            }
            if (this.lowerPoint != null) {
                return this.lowerPoint.distance(pos) <= (double)distance;
            }
            if (this.higherPoint != null) {
                return this.higherPoint.distance(pos) <= (double)distance;
            }
        }
        return false;
    }

    public Cube cropToWorld() {
        Pos one = this.min();
        Pos two = this.max();
        if (this.min().y() < 0.0) {
            one = new Pos(this.min().x(), 0.0, this.min().y());
        }
        if (this.max().y() > 255.0) {
            two = new Pos(this.min().x(), 255.0, this.min().y());
        }
        this.set(one, two);
        return this;
    }

    public Cube expand(int range) {
        Pos start = (Pos)this.min().sub(range);
        Pos end = (Pos)this.max().add(range);
        this.set(start, end);
        return this;
    }
}

