/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.region;

import com.builtbroken.atomic.lib.transform.region.Shape2D;
import com.builtbroken.atomic.lib.transform.region.Triangle;
import com.builtbroken.atomic.lib.transform.vector.Point;
import com.builtbroken.jlib.data.vector.IPos2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Rectangle
extends Shape2D {
    Point min;
    Point max;

    public Rectangle(Point min, Point max) {
        super((Point)min.midpoint(max));
        this.min = min;
        this.max = max;
    }

    public Rectangle() {
        this(new Point(), new Point());
    }

    public Rectangle(Point vec, double expansion) {
        this(vec, (Point)vec.add(expansion));
    }

    public Rectangle(double minX, double minY, double maxX, double maxY) {
        this(new Point(minX, minY), new Point(maxX, maxY));
    }

    public Rectangle(Rectangle rect) {
        this((Point)rect.min.clone(), (Point)rect.max.clone());
    }

    @Override
    public boolean isWithin(IPos2D p) {
        return p.y() >= this.min.y() && p.y() <= this.max.y() && p.x() >= this.min.x() && p.x() <= this.max.x();
    }

    public boolean isWithin_rotated(IPos2D p) {
        double areaDA;
        double areaCD;
        double areaBC;
        Point cornerA = this.cornerA();
        Point cornerB = this.cornerB();
        Point cornerC = this.cornerC();
        Point cornerD = this.cornerD();
        double areaAB = new Triangle(cornerA, cornerB, p).getArea();
        return areaAB + (areaBC = new Triangle(cornerB, cornerC, p).getArea()) + (areaCD = new Triangle(cornerC, cornerD, p).getArea()) + (areaDA = new Triangle(cornerD, cornerA, p).getArea()) <= this.getArea();
    }

    public Point cornerA() {
        return this.min;
    }

    public Point cornerB() {
        return new Point(this.min.x(), this.max.y());
    }

    public Point cornerC() {
        return this.max;
    }

    public Point cornerD() {
        return new Point(this.max.x(), this.min.y());
    }

    public boolean intersects(Rectangle region) {
        return region.max.x() > this.min.x() && region.min.x() < this.max.x() && region.max.y() > this.min.y() && region.min.y() < this.max.y();
    }

    @Override
    public double getArea() {
        return this.getSizeX() * this.getSizeY();
    }

    @Override
    public double getSizeX() {
        return this.max.x() - this.min.x();
    }

    @Override
    public double getSizeY() {
        return this.max.y() - this.min.y();
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Rectangle[" + new BigDecimal(this.min.x(), cont) + ", " + new BigDecimal(this.min.y(), cont) + "] -> [" + new BigDecimal(this.max.x(), cont) + ", " + new BigDecimal(this.max.y(), cont) + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof Rectangle) {
            return this.min == ((Rectangle)o).min && this.max == ((Rectangle)o).max;
        }
        return false;
    }

    public Rectangle clone() {
        return new Rectangle(this);
    }
}

