/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.region;

import com.builtbroken.atomic.lib.transform.vector.Pos;
import com.builtbroken.jlib.data.vector.IPos3D;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class Shape3D {
    double yaw = 0.0;
    double pitch = 0.0;
    double roll = 0.0;
    Pos center;

    public Shape3D(Pos center) {
        this.center = center;
    }

    public Shape3D(NBTTagCompound nbt) {
        this(new Pos(nbt.func_74775_l("center")));
        this.yaw = nbt.func_74769_h("yaw");
        this.pitch = nbt.func_74769_h("pitch");
        this.roll = nbt.func_74769_h("roll");
    }

    abstract boolean isWithin(double var1, double var3, double var5);

    abstract double getVolume();

    abstract double getArea();

    abstract double getSizeX();

    abstract double getSizeY();

    abstract double getSizeZ();

    double getSize() {
        double r = this.getSizeX();
        if (this.getSizeY() > r) {
            r = this.getSizeY();
        }
        if (this.getSizeZ() > r) {
            r = this.getSizeZ();
        }
        return r;
    }

    public IPos3D getCenter() {
        return this.center;
    }

    public double distance(IPos3D pos) {
        return this.center.distance(pos);
    }

    public boolean isWithin(IPos3D vec) {
        return this.isWithin(vec.x(), vec.y(), vec.z());
    }

    public boolean isWithin(TileEntity tile) {
        return this.isWithin(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }
}

