/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.config.ConfigRadiation;
import com.builtbroken.atomic.map.RadMaterialMap;
import com.builtbroken.atomic.map.exposure.RadiationMap;
import com.builtbroken.atomic.map.exposure.ThreadRadExposure;
import com.builtbroken.atomic.map.thermal.ThermalMap;
import com.builtbroken.atomic.map.thermal.ThreadThermalAction;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public final class MapHandler {
    public static final String RAD_EXPOSURE_MAP_ID = "atomicscience:radiation_exposure";
    public static final String RAD_MATERIAL_MAP_ID = "atomicscience:radiation_material";
    public static final String THERMAL_MAP_ID = "atomicscience:thermal";
    public static final String NBT_RAD_CHUNK = "atomicscience:radiation_data";
    public static final String NBT_THERMAL_CHUNK = "atomicscience:thermal";
    public static final RadiationMap RADIATION_MAP = new RadiationMap();
    public static final RadMaterialMap MATERIAL_MAP = new RadMaterialMap();
    public static final ThermalMap THERMAL_MAP = new ThermalMap();
    public static ThreadRadExposure THREAD_RAD_EXPOSURE;
    public static ThreadThermalAction THREAD_THERMAL_ACTION;
    public static final MapHandler INSTANCE;

    public static void register() {
        AtomicScienceAPI.radiationExposureSystem = RADIATION_MAP;
        AtomicScienceAPI.radioactiveMaterialSystem = MATERIAL_MAP;
        AtomicScienceAPI.thermalSystem = THERMAL_MAP;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        if (ConfigRadiation.ENABLE_MAP) {
            MinecraftForge.EVENT_BUS.register((Object)RADIATION_MAP);
            FMLCommonHandler.instance().bus().register((Object)RADIATION_MAP);
        }
        MinecraftForge.EVENT_BUS.register((Object)THERMAL_MAP);
        FMLCommonHandler.instance().bus().register((Object)THERMAL_MAP);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        RADIATION_MAP.onWorldUnload(event.world);
        MATERIAL_MAP.onWorldUnload(event.world);
        THERMAL_MAP.onWorldUnload(event.world);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        RADIATION_MAP.onWorldTick(event.world);
        MATERIAL_MAP.onWorldTick(event.world);
        THERMAL_MAP.onWorldTick(event.world);
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        RADIATION_MAP.onChunkUnload(event.world, event.getChunk());
        MATERIAL_MAP.onChunkUnload(event.world, event.getChunk());
        THERMAL_MAP.onChunkUnload(event.world, event.getChunk());
    }

    @SubscribeEvent
    public void onChunkLoadData(ChunkDataEvent.Load event) {
        RADIATION_MAP.onChunkLoadData(event.world, event.getChunk(), event.getData());
        MATERIAL_MAP.onChunkLoadData(event.world, event.getChunk(), event.getData());
        THERMAL_MAP.onChunkLoadData(event.world, event.getChunk(), event.getData());
    }

    @SubscribeEvent
    public void onChunkSaveData(ChunkDataEvent.Save event) {
        RADIATION_MAP.onChunkSaveData(event.world, event.getChunk(), event.getData());
        MATERIAL_MAP.onChunkSaveData(event.world, event.getChunk(), event.getData());
        THERMAL_MAP.onChunkSaveData(event.world, event.getChunk(), event.getData());
    }

    static {
        INSTANCE = new MapHandler();
    }
}

