/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map;

import com.builtbroken.atomic.map.data.DataMap;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MapSystem {
    protected final String saveKey;
    protected final String id;
    protected final HashMap<Integer, DataMap> dimensionToMap = new HashMap();

    public MapSystem(String id, String saveKey) {
        this.id = id;
        this.saveKey = saveKey;
    }

    public DataMap getMap(int dim, boolean init) {
        DataMap map = this.dimensionToMap.get(dim);
        if (map == null && init) {
            map = this.newMap(dim);
            this.dimensionToMap.put(dim, map);
        }
        return map;
    }

    protected DataMap newMap(int dim) {
        return new DataMap(this, dim);
    }

    public DataMap getMap(World world, boolean init) {
        if (world != null && world.field_73011_w != null) {
            return this.getMap(world.field_73011_w.field_76574_g, init);
        }
        return null;
    }

    public int getData(World world, int x, int y, int z) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            return map.getData(x, y, z);
        }
        return 0;
    }

    public int getData(int dim, int x, int y, int z) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.getData(x, y, z);
        }
        return 0;
    }

    public boolean setData(World world, int x, int y, int z, int amount) {
        DataMap map = this.getMap(world, amount > 0);
        if (map != null) {
            return map.setData(x, y, z, amount);
        }
        return true;
    }

    public boolean setData(int dim, int x, int y, int z, int amount) {
        DataMap map = this.getMap(dim, amount > 0);
        if (map != null) {
            return map.setData(x, y, z, amount);
        }
        return true;
    }

    public void onWorldUnload(World world) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.onWorldUnload();
        }
    }

    public void onWorldTick(World world) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.onWorldTick(world);
        }
    }

    public void onChunkUnload(World world, Chunk chunk) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.unloadChunk(chunk);
        }
    }

    public void onChunkLoadData(World world, Chunk chunk, NBTTagCompound save) {
        NBTTagCompound tag;
        DataMap map;
        if (save != null && this.saveKey != null && save.func_74764_b(this.saveKey) && (map = this.getMap(world, true)) != null && !(tag = save.func_74775_l(this.saveKey)).func_82582_d()) {
            map.loadChunk(chunk, tag);
        }
    }

    public void onChunkSaveData(World world, Chunk chunk, NBTTagCompound save) {
        DataMap map = this.getMap(world, false);
        if (map != null && this.saveKey != null) {
            NBTTagCompound tag = new NBTTagCompound();
            map.saveChunk(chunk, tag);
            if (!tag.func_82582_d()) {
                save.func_74782_a(this.saveKey, (NBTBase)tag);
            }
        }
    }
}

