/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.map.data.DataLayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataChunk {
    public static final String NBT_Y_START = "y_start";
    public static final String NBT_SIZE = "size";
    public static final String NBT_LAYERS = "layers";
    public static final String NBT_LAYER_INDEX = "i";
    public static final String NBT_LAYER_Y = "y";
    public static final String NBT_LAYER_DATA = "data";
    public final int xPosition;
    public final int zPosition;
    public final int dimension;
    public int unloadTick = 0;
    protected DataLayer[] layers = new DataLayer[256];
    protected int yStart;
    public boolean hasChanged = true;

    public DataChunk(int dimension, int xPosition, int zPosition) {
        this.dimension = dimension;
        this.xPosition = xPosition;
        this.zPosition = zPosition;
    }

    protected int getChunkHeight() {
        return 256;
    }

    public boolean setValue(int cx, int y, int cz, int value) {
        if (y >= 0 && y < this.getChunkHeight()) {
            if (value > 0 || this.hasLayer(y)) {
                int prev = this.getLayer(y).getData(cx, cz);
                boolean b = this.getLayer(y).setData(cx, cz, value);
                if (this.getLayer(y).isEmpty()) {
                    this.removeLayer(y);
                }
                if (prev != this.getLayer(y).getData(cx, cz)) {
                    this.hasChanged = true;
                }
                return b;
            }
            return true;
        }
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("Something tried to place a block outside map", (Throwable)new RuntimeException("trace"));
        }
        return false;
    }

    public int getValue(int cx, int y, int cz) {
        if (y >= 0 && y < this.getChunkHeight() && this.hasLayer(y)) {
            return this.getLayer(y).getData(cx, cz);
        }
        return 0;
    }

    protected boolean hasLayer(int y) {
        return this.getLayers() != null && y >= this.getYStart() && y <= this.getLayerEnd() && this.getLayers()[this.getIndex(y)] != null;
    }

    public int getLayerEnd() {
        return this.getYStart() + this.getLayers().length - 1;
    }

    protected void removeLayer(int y) {
        int index = this.getIndex(y);
        if (index >= 0 && index < this.getLayers().length) {
            this.getLayers()[index] = null;
        }
    }

    public DataLayer getLayer(int y) {
        if (this.getLayers()[this.getIndex(y)] == null) {
            this.getLayers()[this.getIndex((int)y)] = new DataLayer(y);
        }
        return this.getLayers()[this.getIndex(y)];
    }

    protected int getIndex(int y) {
        return y - this.getYStart();
    }

    public void save(NBTTagCompound tag) {
        if (this.getLayers() != null) {
            tag.func_74768_a(NBT_Y_START, this.getYStart());
            tag.func_74768_a(NBT_SIZE, this.getLayers().length);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.getLayers().length; ++i) {
                DataLayer layer = this.getLayers()[i];
                if (layer == null || layer.isEmpty()) continue;
                NBTTagCompound save = new NBTTagCompound();
                save.func_74768_a(NBT_LAYER_INDEX, i);
                save.func_74768_a(NBT_LAYER_Y, layer.y_index);
                save.func_74783_a(NBT_LAYER_DATA, layer.data);
                list.func_74742_a((NBTBase)save);
            }
            tag.func_74782_a(NBT_LAYERS, (NBTBase)list);
        }
    }

    public void load(NBTTagCompound tag) {
        this.yStart = tag.func_74762_e(NBT_Y_START);
        int size = tag.func_74762_e(NBT_SIZE);
        this.layers = new DataLayer[size];
        NBTTagList list = tag.func_150295_c(NBT_LAYERS, 10);
        for (int list_index = 0; list_index < list.func_74745_c(); ++list_index) {
            NBTTagCompound save = list.func_150305_b(list_index);
            int index = save.func_74762_e(NBT_LAYER_INDEX);
            int y = save.func_74762_e(NBT_LAYER_Y);
            DataLayer layer = new DataLayer(y);
            int[] data = save.func_74759_k(NBT_LAYER_DATA);
            if (data.length != layer.data.length) {
                AtomicScience.logger.error(String.format("RadiationChunk[%sd, %scx, %scz]#load(NBT) layer[%s] -> data array has invalid size, will attempt to read in as much as possible. This may resultin radiation values changing per position for the given y level.", this.dimension, this.xPosition, this.zPosition, y));
            }
            for (int j = 0; j < data.length && j < layer.data.length; ++j) {
                layer.data[j] = data[j];
                if (data[j] == 0) continue;
                ++layer.blocksUsed;
            }
            this.getLayers()[index] = layer;
        }
    }

    public DataLayer[] getLayers() {
        return this.layers;
    }

    public int getYStart() {
        return this.yStart;
    }
}

