/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.map.MapSystem;
import com.builtbroken.atomic.map.data.DataChunk;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

public class DataMap {
    public final MapSystem mapSystem;
    public final int dim;
    protected final HashMap<Long, DataChunk> chunksCurrentlyLoaded = new HashMap();
    protected final HashMap<Long, DataChunk> chunksWaitingToUnload = new HashMap();

    public DataMap(MapSystem mapSystem, int dim) {
        this.mapSystem = mapSystem;
        this.dim = dim;
    }

    public int getData(int x, int y, int z) {
        DataChunk chunk = this.getChunkFromPosition(x, z, false);
        if (chunk != null) {
            return chunk.getValue(x & 0xF, y, z & 0xF);
        }
        return 0;
    }

    public boolean setData(int x, int y, int z, int amount) {
        DataChunk chunk = this.getChunkFromPosition(x, z, amount > 0);
        if (chunk != null) {
            Chunk worldChunk;
            WorldServer world;
            int prev_value = this.getData(x, y, z);
            MapSystemEvent.UpdateValue event = new MapSystemEvent.UpdateValue(this, x, y, z, prev_value, amount);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            amount = event.new_value;
            boolean hasChanged = chunk.setValue(x & 0xF, y, z & 0xF, amount);
            if (hasChanged && (world = DimensionManager.getWorld((int)this.dim)) != null && (worldChunk = world.func_72938_d(x, z)) != null) {
                worldChunk.func_76630_e();
            }
            return hasChanged;
        }
        return true;
    }

    public boolean blockExists(int x, int y, int z) {
        World world = this.getWorld();
        return world != null && world.func_72899_e(x, y, z);
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    public void onWorldUnload() {
        this.chunksCurrentlyLoaded.clear();
    }

    public void onWorldTick(World world) {
        Iterator<Map.Entry<Long, DataChunk>> it = this.chunksWaitingToUnload.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, DataChunk> entry = it.next();
            DataChunk chunk = entry.getValue();
            if (chunk == null) {
                it.remove();
                continue;
            }
            if (world.func_72863_F().func_73149_a(chunk.xPosition, chunk.zPosition)) {
                this.chunksCurrentlyLoaded.put(entry.getKey(), chunk);
                it.remove();
                continue;
            }
            if (entry.getValue().unloadTick++ <= 1000) continue;
            MinecraftForge.EVENT_BUS.post((Event)new MapSystemEvent.RemoveChunk(this, entry.getValue()));
            it.remove();
        }
    }

    public void unloadChunk(Chunk chunk) {
        long index = this.index(chunk);
        if (this.chunksCurrentlyLoaded.containsKey(index)) {
            this.chunksWaitingToUnload.put(index, this.chunksCurrentlyLoaded.get(index));
            this.chunksCurrentlyLoaded.remove(index);
        }
    }

    public void saveChunk(Chunk chunk, NBTTagCompound data) {
        long index = this.index(chunk);
        DataChunk radiationChunk = this.findChunk(index, true);
        if (radiationChunk != null) {
            radiationChunk.save(data);
        }
    }

    public void loadChunk(Chunk chunk, NBTTagCompound data) {
        DataChunk radiationChunk = this.getChunk(chunk.field_76635_g, chunk.field_76647_h, true);
        radiationChunk.load(data);
        if (radiationChunk != null) {
            MinecraftForge.EVENT_BUS.post((Event)new MapSystemEvent.AddChunk(this, radiationChunk));
        }
    }

    protected DataChunk createNewChunk(int dim, int chunkX, int chunkZ) {
        long index = this.index(chunkX, chunkZ);
        DataChunk radiationChunk = new DataChunk(dim, chunkX, chunkZ);
        this.chunksCurrentlyLoaded.put(index, radiationChunk);
        return radiationChunk;
    }

    public DataChunk getChunkFromPosition(int x, int z, boolean init) {
        return this.getChunk(x >> 4, z >> 4, init);
    }

    public DataChunk getChunk(int chunk_x, int chunk_z, boolean init) {
        DataChunk chunk = this.findChunk(chunk_x, chunk_z, init);
        if (chunk == null && init) {
            chunk = this.createNewChunk(this.dim, chunk_x, chunk_z);
        }
        return chunk;
    }

    protected DataChunk findChunk(int chunk_x, int chunk_z, boolean load) {
        return this.findChunk(this.index(chunk_x, chunk_z), load);
    }

    protected DataChunk findChunk(long index, boolean load) {
        DataChunk chunk = this.chunksCurrentlyLoaded.get(index);
        if (chunk == null && load && (chunk = this.chunksWaitingToUnload.get(index)) != null) {
            this.chunksWaitingToUnload.remove(index);
            this.chunksCurrentlyLoaded.put(index, chunk);
        }
        return chunk;
    }

    protected long index(Chunk chunk) {
        return this.index(chunk.field_76635_g, chunk.field_76647_h);
    }

    protected long index(int chunkX, int chunkZ) {
        return ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
    }
}

