/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.map.data.DataPool;
import com.builtbroken.jlib.data.vector.IPos3D;
import net.minecraftforge.common.util.ForgeDirection;

public class DataPos
implements IPos3D {
    private static final DataPool<DataPos> dataPosPool = new DataPool(100000);
    public int x;
    public int y;
    public int z;

    protected DataPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static DataPos get(DataPos pos, ForgeDirection direction) {
        int i = pos.x + direction.offsetX;
        int j = pos.y + direction.offsetY;
        int k = pos.z + direction.offsetZ;
        return DataPos.get(i, j, k);
    }

    public static DataPos get(int x, int y, int z, ForgeDirection direction) {
        int i = x + direction.offsetX;
        int j = y + direction.offsetY;
        int k = z + direction.offsetZ;
        return DataPos.get(i, j, k);
    }

    public static DataPos get(int x, int y, int z) {
        DataPos dataPos;
        if (dataPosPool.has() && (dataPos = dataPosPool.get()) != null) {
            dataPos.x = x;
            dataPos.y = y;
            dataPos.z = z;
            return dataPos;
        }
        return new DataPos(x, y, z);
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DataPos) {
            return this.x == ((DataPos)object).x && this.y == ((DataPos)object).y && this.z == ((DataPos)object).z;
        }
        return false;
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 31 + this.x;
        hash = hash * 31 + this.y;
        hash = hash * 31 + this.z;
        return hash;
    }

    public String toString() {
        return "DataPos[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void dispose() {
        dataPosPool.dispose(this);
    }
}

