/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataChunk;
import com.builtbroken.atomic.map.data.DataLayer;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ThreadDataChange
extends Thread {
    public final String name;
    public boolean shouldRun = true;
    private ConcurrentLinkedQueue<DataChange> changeQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DataChunk> addScanQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DataChunk> removeScanQueue = new ConcurrentLinkedQueue();

    public ThreadDataChange(String name) {
        super(null, null, "atomicscience:" + name, 0L);
        this.name = name;
        this.setPriority(3);
        this.setDaemon(true);
    }

    @Override
    public void start() {
        this.shouldRun = true;
        AtomicScience.logger.info(this.name + ": Starting thread");
        super.start();
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                while (this.shouldRun && !this.removeScanQueue.isEmpty()) {
                    this.queueRemove(this.removeScanQueue.poll());
                }
                while (this.shouldRun && !this.addScanQueue.isEmpty()) {
                    this.queueAddition(this.addScanQueue.poll());
                }
                while (this.shouldRun && !this.changeQueue.isEmpty() && this.addScanQueue.isEmpty() && this.removeScanQueue.isEmpty()) {
                    DataChange change = this.changeQueue.poll();
                    if (change != null) {
                        this.updateLocation(change);
                    }
                    change.dispose();
                }
                ThreadDataChange.sleep(100L);
            }
            catch (Exception e) {
                AtomicScience.logger.error(this.name + ": Unexpected error during operation", (Throwable)e);
            }
        }
        this.removeScanQueue.clear();
        this.addScanQueue.clear();
        this.changeQueue.clear();
    }

    protected void queueRemove(DataChunk chunk) {
        if (chunk != null) {
            for (DataLayer layer : chunk.getLayers()) {
                for (int cx = 0; cx < 16; ++cx) {
                    for (int cz = 0; cz < 16; ++cz) {
                        if (layer == null || layer.getData(cx, cz) <= 0) continue;
                        int x = cx + chunk.xPosition * 16;
                        int z = cz + chunk.xPosition * 16;
                        this.changeQueue.add(new DataChange(chunk.dimension, x, layer.y_index, z, layer.getData(cx, cz), 0));
                    }
                }
            }
        }
    }

    protected void queueAddition(DataChunk chunk) {
        if (chunk != null) {
            for (DataLayer layer : chunk.getLayers()) {
                for (int cx = 0; cx < 16; ++cx) {
                    for (int cz = 0; cz < 16; ++cz) {
                        if (layer == null || layer.getData(cx, cz) <= 0) continue;
                        int x = cx + chunk.xPosition * 16;
                        int z = cz + chunk.xPosition * 16;
                        this.changeQueue.add(new DataChange(chunk.dimension, x, layer.y_index, z, 0, layer.getData(cx, cz)));
                    }
                }
            }
        }
    }

    protected boolean inRange(int x, int y, int z, int i, int j, int k, int range) {
        return this.inRange(x, i, range) && this.inRange(y, j, range) && this.inRange(z, k, range);
    }

    protected boolean inRange(int x, int i, int range) {
        int delta = x - i;
        return delta < range && delta > -range;
    }

    protected abstract void updateLocation(DataChange var1);

    public void kill() {
        this.shouldRun = false;
        AtomicScience.logger.info(this.name + ": Stopping thread");
    }

    public void queueChunkForRemoval(DataChunk chunk) {
        if (chunk != null) {
            this.removeScanQueue.add(chunk);
        }
    }

    public void queueChunkForAddition(DataChunk chunk) {
        if (chunk != null) {
            this.addScanQueue.add(chunk);
        }
    }

    public void queuePosition(DataChange radChange) {
        if (radChange != null) {
            this.changeQueue.add(radChange);
        }
    }
}

